/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.resource;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationListener;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.resource.ResourceControlRequestService;
import com.ur.util.event.EventManager;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ResourceControlRequestServiceImpl
implements ResourceControlRequestService,
InstallationListener,
InstallationStateListener {
    private volatile boolean enable;
    private Map<Class<?>, Set<Object>> requests = new HashMap();
    private Map<Class<?>, Set<Object>> requestsBackup = new HashMap();

    @Inject
    public ResourceControlRequestServiceImpl(EventManager eventManager) {
        eventManager.addStrongListener(InstallationListener.class, (Object)this);
        eventManager.addStrongListener(InstallationStateListener.class, (Object)this);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void addRequest(Class<?> type, Object request) {
        if (!this.isEnable()) {
            return;
        }
        Set<Object> set = this.requests.get(type);
        if (set == null) {
            set = new LinkedHashSet<Object>();
            this.requests.put(type, set);
        }
        set.add(request);
    }

    public Object[] getRequests(Class<?> type) {
        Set<Object> set = this.requests.get(type);
        if (set == null) {
            return new Object[0];
        }
        return set.toArray();
    }

    public void clear() {
        this.requests.clear();
    }

    public void onInstallationEvent(InstallationListener.Event event) {
        if (event.getType() != InstallationListener.EventType.RESET_INSTALLATION_URCAPS && event.getType() != InstallationListener.EventType.PRE_LOAD_INSTALLATION) {
            return;
        }
        this.backupRequests();
        this.clear();
    }

    private void clearBackup() {
        this.requestsBackup.clear();
    }

    private void backupRequests() {
        this.clearBackup();
        this.requestsBackup.putAll(this.requests);
    }

    private void restoreBackup() {
        this.clear();
        this.requests.putAll(this.requestsBackup);
    }

    public void installationLoaded(Installation installation) {
        this.clearBackup();
    }

    public void installationLoadFailed() {
        this.restoreBackup();
    }

    public void installationModified() {
    }

    public void installationSaved() {
    }
}

