/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.resource;

import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.ShutdownHookService;
import com.ur.polyscope.installation.internal.resource.RequestHandler;
import com.ur.polyscope.installation.internal.resource.RequestRegister;
import com.ur.polyscope.installation.internal.resource.ResourceRegister;
import com.ur.polyscope.installation.resource.ResourceControlRequest;
import com.ur.polyscope.installation.resource.ResourceControlService;
import com.ur.polyscope.installation.resource.ResourceControlSettings;
import com.ur.polyscope.installation.resource.ResourceControlStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ResourceControlServiceImpl
implements ResourceControlService {
    private final ResourceRegister resourceRegister = new ResourceRegister();
    private final RequestRegister requestRegister = new RequestRegister();
    private final Map<String, RequestHandler> grantedRequests = new HashMap<String, RequestHandler>();
    private final InstallationComponentLookup installationComponentLookup;
    private final ShutdownHookService shutdownHookService;

    @Inject
    public ResourceControlServiceImpl(InstallationComponentLookup installationComponentLookup, ShutdownHookService shutdownHookService) {
        this.installationComponentLookup = installationComponentLookup;
        this.shutdownHookService = shutdownHookService;
        this.registerShutdownHook();
    }

    private void registerShutdownHook() {
        this.shutdownHookService.addShutdownHook(ShutdownHookService.Stage.REVOKE_RESOURCE_CONTROL, (Runnable)new RevokeControlRunner());
    }

    private void revokeControl() {
        for (RequestHandler requestHandler : this.grantedRequests.values()) {
            this.revokeControl(requestHandler.getRequest().getResourceId());
        }
    }

    public boolean grantControl(ResourceControlRequest request) {
        String resourceId = request.getResourceId();
        if (!this.resourceRegister.hasResource(resourceId)) {
            return false;
        }
        RequestHandler requestHandler = this.requestRegister.getRequestHandler(request);
        if (requestHandler == null) {
            return false;
        }
        this.revokeControl(resourceId);
        this.grantedRequests.put(resourceId, requestHandler);
        requestHandler.onGrantControl();
        ResourceControlSettings settings = (ResourceControlSettings)this.installationComponentLookup.getComponent(ResourceControlSettings.class);
        settings.addResourceControllerInfo(resourceId, request.getResourceControllerInfo());
        return true;
    }

    public boolean revokeControl(String resourceId) {
        RequestHandler requestHandler = this.grantedRequests.get(resourceId);
        if (requestHandler == null) {
            return false;
        }
        this.grantedRequests.remove(resourceId);
        requestHandler.onRevokeControl();
        ResourceControlSettings settings = (ResourceControlSettings)this.installationComponentLookup.getComponent(ResourceControlSettings.class);
        settings.removeResourceControllerInfo(resourceId);
        return true;
    }

    public void registerResource(String resourceId, Provider provider, ResourceControlStrategy controlStrategy) {
        this.resourceRegister.register(resourceId, provider, controlStrategy);
    }

    public boolean removeRequest(ResourceControlRequest request) {
        RequestHandler requestHandler = this.requestRegister.getRequestHandler(request);
        if (requestHandler == null) {
            return false;
        }
        if (requestHandler.hasControl()) {
            this.revokeControl(requestHandler.getRequest().getResourceId());
        }
        this.requestRegister.removeRequestHandler(requestHandler);
        request.setHasControl(null);
        return true;
    }

    public List<ResourceControlRequest> getRequestsByResourceId(String resourceId) {
        return this.requestRegister.getRequestsByResourceId(resourceId);
    }

    public boolean requestControl(ResourceControlRequest request) {
        RequestHandler requestHandler = this.requestRegister.getRequestHandler(request);
        if (requestHandler != null) {
            return false;
        }
        String resourceId = request.getResourceId();
        Provider resourceProvider = this.resourceRegister.getResourceProvider(resourceId);
        ResourceControlStrategy strategy = this.resourceRegister.getResourceControlStrategy(resourceId);
        requestHandler = new RequestHandler(resourceProvider, request, (ResourceControlStrategy<Object, Object>)strategy);
        this.requestRegister.addRequestHandler(requestHandler);
        return true;
    }

    public void removeMissingRequests(String resourceControllerId) {
        List<ResourceControlRequest> toRemove = this.requestRegister.getMissingRequestsByResourceControllerId(resourceControllerId);
        for (ResourceControlRequest request : toRemove) {
            this.removeRequest(request);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceControlService {");
        sb.append(this.resourceRegister);
        sb.append(", ");
        sb.append(this.requestRegister);
        sb.append("}");
        return sb.toString();
    }

    private class RevokeControlRunner
    implements Runnable {
        private RevokeControlRunner() {
        }

        @Override
        public void run() {
            ResourceControlServiceImpl.this.revokeControl();
        }
    }
}

