/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.resource;

import com.ur.polyscope.installation.resource.ResourceControlStrategy;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
class ResourceRegister {
    private final Map<String, Provider> providers = new HashMap<String, Provider>();
    private final Map<String, ResourceControlStrategy> strategies = new HashMap<String, ResourceControlStrategy>();

    ResourceRegister() {
    }

    void register(String resourceId, Provider provider, ResourceControlStrategy controlStrategy) {
        this.providers.put(resourceId, provider);
        this.strategies.put(resourceId, controlStrategy);
    }

    boolean hasResource(String id) {
        return this.providers.containsKey(id);
    }

    Provider getResourceProvider(String id) {
        return this.providers.get(id);
    }

    ResourceControlStrategy getResourceControlStrategy(String id) {
        return this.strategies.get(id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Resources[");
        for (String id : this.providers.keySet()) {
            sb.append(id).append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

