/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.services;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.MetaData;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.domain.PostCreateInstallation;
import com.ur.polyscope.installation.domain.PreCreateInstallation;
import com.ur.polyscope.installation.domain.UnderWayInstallation;
import com.ur.polyscope.installation.services.RobotInstallationCreator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;

public class DefaultRobotInstallationCreator
implements RobotInstallationCreator {
    private Set<PreCreateInstallation> preCreateInstallations;
    private final Set<PostCreateInstallation> postCreateInstallations;
    private final Set<UnderWayInstallation> underWayInstallations;
    private final Provider<Installation> robotInstallationProvider;

    @Inject
    public DefaultRobotInstallationCreator(Set<PreCreateInstallation> preCreateInstallations, Set<UnderWayInstallation> underWayInstallations, Set<PostCreateInstallation> postCreateInstallations, Provider<Installation> robotInstallationProvider) {
        this.preCreateInstallations = preCreateInstallations;
        this.underWayInstallations = underWayInstallations;
        this.postCreateInstallations = postCreateInstallations;
        this.robotInstallationProvider = robotInstallationProvider;
    }

    public Installation createDefaultWith(String name, Set<InstallationComponent> installationComponents) {
        Installation robotInstallation = this.createRobotInstallation();
        PersistanceMetaData persistanceMetaData = (PersistanceMetaData)robotInstallation.getMetaData(PersistanceMetaData.class);
        robotInstallation.setMetaData((MetaData)new PersistanceMetaData(persistanceMetaData.directory(), name));
        for (InstallationComponent installationComponent : installationComponents) {
            robotInstallation.setComponent(installationComponent);
        }
        for (PostCreateInstallation each : this.postCreateInstallations) {
            each.postCreate(robotInstallation);
        }
        return robotInstallation;
    }

    public Installation createRobotInstallation() {
        for (PreCreateInstallation each : this.preCreateInstallations) {
            each.preCreate();
        }
        return this.getRobotInstallation();
    }

    public Installation createRobotInstallationIgnoreContributions() {
        for (PreCreateInstallation each : this.preCreateInstallations) {
            each.preCreate();
        }
        return this.getRobotInstallation();
    }

    private Installation getRobotInstallation() {
        Installation robotInstallation = (Installation)this.robotInstallationProvider.get();
        for (UnderWayInstallation underWayInstallation : this.underWayInstallations) {
            underWayInstallation.installationUnderWay(robotInstallation);
        }
        return robotInstallation;
    }
}

