/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver;

import com.ur.polyscope.installation.internal.urcapdriver.ColumnLayoutStrategy$ShowKeyboardOnClick$1$AjcClosure1;
import com.ur.polyscope.installation.internal.urcapdriver.LogoLabelFactory;
import com.ur.polyscope.installation.internal.urcapdriver.common.AbstractUserInput;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElementLayoutStrategy;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.swing.FormBuilder;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.NumberField;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.util.swing.HTML;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ColumnLayoutStrategy
implements ViewElementLayoutStrategy {
    private final WidgetFactory widgetFactory;
    private final FormBuilder panel;
    private final UserInteraction userInteraction;
    private FormBuilder.PanelConstraints labelWidth;
    private FormBuilder.PanelConstraints componentWidth;
    private FormBuilder.PanelConstraints headerWidth;
    private int iconSize;
    private boolean addLabelSpacer;
    private String labelLeft;
    private JComponent widgetLeft;

    public ColumnLayoutStrategy(WidgetFactory widgetFactory, FormBuilder panel, UserInteraction userInteraction) {
        this.widgetFactory = widgetFactory;
        this.panel = panel;
        this.userInteraction = userInteraction;
    }

    public void setLabelAndComponentWidths(FormBuilder.PanelConstraints labelWidth, FormBuilder.PanelConstraints componentWidth) {
        this.labelWidth = labelWidth;
        this.componentWidth = componentWidth;
    }

    public void setHeaderAndIconWidth(FormBuilder.PanelConstraints headerWidth, int iconSize) {
        this.headerWidth = headerWidth;
        this.iconSize = iconSize;
    }

    public void setAddLabelSpacer(boolean addLabelSpacer) {
        this.addLabelSpacer = addLabelSpacer;
    }

    @Override
    public JTextField createTextField(AbstractUserInput<String> userInput) {
        KeyboardInputFactory keyboardInputFactory = this.userInteraction.getKeyboardInputFactory();
        JTextField textField = new JTextField();
        textField.setHorizontalAlignment(4);
        textField.addMouseListener(new ShowKeyboardOnClick(userInput, keyboardInputFactory));
        return textField;
    }

    @Override
    public NumberField createNumberField(ActionListener setValue) {
        return this.widgetFactory.createNumberField(setValue);
    }

    @Override
    public JLabel createLabel(String text, Icon icon) {
        Icon scaledIcon = LogoLabelFactory.createScaledLogo((ImageIcon)icon, this.iconSize, this.iconSize);
        return new CleanJLabel(HTML.unHtml((String)text), scaledIcon, this.iconSize);
    }

    @Override
    public void setHeader(String headerText) {
        this.panel.description(headerText, new FormBuilder.PanelConstraints[]{this.headerWidth, FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3);
        this.panel.end();
    }

    @Override
    public void setHeader(String headerText, Icon logo) {
        JLabel image = new JLabel();
        image.setIcon(logo);
        image.setHorizontalAlignment(4);
        this.panel.description(headerText, new FormBuilder.PanelConstraints[]{this.headerWidth, FormBuilder.PanelConstraints.SPAN_3_ROWS}).label(image, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(3);
        this.panel.end();
    }

    @Override
    public void add(String label, JComponent component) {
        if (this.labelLeft == null) {
            this.labelLeft = label;
            this.widgetLeft = component;
        } else {
            this.panel.label(HTML.unHtml((String)this.labelLeft), new FormBuilder.PanelConstraints[]{this.labelWidth});
            if (this.addLabelSpacer) {
                this.panel.spacer();
            }
            this.panel.label(HTML.unHtml((String)label), new FormBuilder.PanelConstraints[]{this.labelWidth}).end();
            this.panel.component(this.widgetLeft, new FormBuilder.PanelConstraints[]{this.componentWidth}).spacer().component(component, new FormBuilder.PanelConstraints[]{this.componentWidth}).end();
            this.labelLeft = null;
            this.widgetLeft = null;
        }
    }

    @Override
    public void finalizeLayout() {
        if (this.labelLeft != null) {
            this.panel.label(this.labelLeft, new FormBuilder.PanelConstraints[]{this.labelWidth}).end().component(this.widgetLeft, new FormBuilder.PanelConstraints[]{this.componentWidth}).end();
        }
    }

    private static class CleanJLabel
    extends JLabel {
        private final int iconSize;

        public CleanJLabel(String s, Icon scaledIcon, int iconSize) {
            super(s, scaledIcon, 2);
            this.iconSize = iconSize;
        }

        @Override
        public void setIcon(Icon icon) {
            if (icon == null || this.iconSize == 0) {
                super.setIcon(icon);
                return;
            }
            Icon scaledIcon = LogoLabelFactory.createScaledLogo((ImageIcon)icon, this.iconSize, this.iconSize);
            super.setIcon(scaledIcon);
        }

        @Override
        public void setText(String text) {
            super.setText(HTML.unHtml((String)text));
        }
    }

    private static class ShowKeyboardOnClick
    extends MouseAdapter {
        private final AbstractUserInput<String> userInput;
        private final KeyboardInputFactory keyboardInputFactory;

        public ShowKeyboardOnClick(AbstractUserInput<String> userInput, KeyboardInputFactory keyboardInputFactory) {
            this.userInput = userInput;
            this.keyboardInputFactory = keyboardInputFactory;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            final JTextField textField = (JTextField)e.getSource();
            KeyboardTextInput keyboardInput = this.createKeyboard(this.keyboardInputFactory);
            keyboardInput.setErrorValidator(this.userInput.getValidator());
            keyboardInput.setInitialValue(this.userInput.getValue());
            keyboardInput.show(textField, (KeyboardInputCallback)new KeyboardInputCallback<String>(){
                private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

                public void onOk(String value) {
                    String string = value;
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
                    Object[] objectArray = new Object[]{this, string, joinPoint};
                    ColumnLayoutStrategy$ShowKeyboardOnClick$1$AjcClosure1 columnLayoutStrategy$ShowKeyboardOnClick$1$AjcClosure1 = new ColumnLayoutStrategy$ShowKeyboardOnClick$1$AjcClosure1(objectArray);
                    UncaughtExceptionAspect.aspectOf().aroundMethod(columnLayoutStrategy$ShowKeyboardOnClick$1$AjcClosure1.linkClosureAndJoinPoint(69648));
                }

                static {
                    1.ajc$preClinit();
                }

                static final /* synthetic */ void onOk_aroundBody0(1 ajc$this, String value, JoinPoint joinPoint) {
                    userInput.setValue(value);
                    ajc$this.textField.setText((String)userInput.getValue());
                }

                private static /* synthetic */ void ajc$preClinit() {
                    Factory factory = new Factory("ColumnLayoutStrategy.java", 1.class);
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onOk", "com.ur.polyscope.installation.internal.urcapdriver.ColumnLayoutStrategy$ShowKeyboardOnClick$1", "java.lang.String", "value", "", "void"), 165);
                }
            });
        }

        private KeyboardTextInput createKeyboard(KeyboardInputFactory keyboardInputFactory) {
            return keyboardInputFactory.createStringKeyboardInput();
        }
    }
}

