/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.ur.polyscope.installation.internal.urcapdriver.common.AbstractUserInput;
import com.ur.polyscope.installation.internal.urcapdriver.common.HasID;
import com.ur.polyscope.installation.internal.urcapdriver.common.WidgetBuilder;
import com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput;
import com.ur.polyscope.installation.internal.urcapdriver.string.TextComponentImpl;
import com.ur.urcap.api.contribution.driver.general.userinput.IDAlreadyDefined;
import com.ur.urcap.api.contribution.driver.general.userinput.TooManyUserInputsRegistered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;

class RegisteredUserInputs {
    public static final int MAX_NUMBER_OF_ELEMENTS_SUPPORTED = 10;
    private LinkedHashMap<String, WidgetBuilder> idToWidgetBuilder = new LinkedHashMap();
    private List<AbstractUserInput> inputs = new ArrayList<AbstractUserInput>();
    private HashSet<HasID> toBeDeprecated = new HashSet();

    RegisteredUserInputs() {
    }

    public WidgetBuilder registerInput(AbstractUserInput input, WidgetBuilder installationElement) {
        this.inputs.add(input);
        return this.register(input.getId(), installationElement);
    }

    public WidgetBuilder registerSelectableInput(ComboBoxInput input, WidgetBuilder installationElement) {
        this.inputs.add(input.getUserInput());
        return this.register(input.getId(), installationElement);
    }

    public void registerText(TextComponentImpl result) {
        this.register(UUID.randomUUID().toString(), result);
    }

    private WidgetBuilder register(String id, WidgetBuilder installationElement) {
        if (this.numberOfElementsToBeShown() == 10) {
            throw new TooManyUserInputsRegistered(String.format("A maximum of %d user inputs and/or UI elements can be registered", 10));
        }
        if (this.idToWidgetBuilder.containsKey(id)) {
            throw new IDAlreadyDefined(String.format("Key '%s' has already been defined.", id));
        }
        return this.idToWidgetBuilder.put(id, installationElement);
    }

    public boolean containsId(String key) {
        return this.idToWidgetBuilder.containsKey(key);
    }

    public Iterable<WidgetBuilder> widgetBuilders() {
        for (HasID each : this.toBeDeprecated) {
            this.idToWidgetBuilder.remove(each.getId());
        }
        return this.idToWidgetBuilder.values();
    }

    public void deprecate(HasID userInput) {
        this.toBeDeprecated.add(userInput);
    }

    public int numberOfElementsToBeShown() {
        return this.elementsToBeShown().size();
    }

    private Collection<String> elementsToBeShown() {
        return Collections2.filter(this.idToWidgetBuilder.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                for (HasID hasID : RegisteredUserInputs.this.toBeDeprecated) {
                    if (!hasID.getId().equals(key)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public Collection<AbstractUserInput> activeInputs() {
        return Collections2.filter(this.inputs, (Predicate)new Predicate<AbstractUserInput>(){

            public boolean apply(AbstractUserInput abstractUserInput) {
                return abstractUserInput instanceof HasID && RegisteredUserInputs.this.idToWidgetBuilder.containsKey(abstractUserInput.getId()) && !RegisteredUserInputs.this.toBeDeprecated.contains(abstractUserInput);
            }
        });
    }

    public Iterable<HasID> deprecated() {
        return new ArrayList<HasID>(this.toBeDeprecated);
    }
}

