/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver.bool;

import com.ur.polyscope.installation.internal.urcapdriver.bool.BooleanInput;
import com.ur.polyscope.installation.internal.urcapdriver.common.AbstractUserInput;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElement;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElementLayoutStrategy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class CheckBoxElement
implements ViewElement {
    private final BooleanInput userInput;
    private JCheckBox checkBox;

    public CheckBoxElement(ViewElementLayoutStrategy layoutStrategy, String label, BooleanInput userInput) {
        this.userInput = userInput;
        this.init(userInput.id, label);
        this.layout(layoutStrategy);
        this.addListeners(userInput);
    }

    private void init(String id, String label) {
        this.checkBox = new JCheckBox();
        this.checkBox.setName(String.valueOf(id) + ".InstallationNodeView");
        this.checkBox.setText(label);
    }

    private void layout(ViewElementLayoutStrategy layoutStrategy) {
        layoutStrategy.add("", this.checkBox);
    }

    private void addListeners(BooleanInput userInput) {
        this.checkBox.addActionListener(new UpdateDataModelOnClick(userInput, this.checkBox));
    }

    @Override
    public void update() {
        this.checkBox.setSelected((Boolean)this.userInput.getValue());
    }

    private static class UpdateDataModelOnClick
    implements ActionListener {
        private final AbstractUserInput<Boolean> userInput;
        private final JCheckBox checkBox;

        public UpdateDataModelOnClick(AbstractUserInput<Boolean> userInput, JCheckBox checkBox) {
            this.userInput = userInput;
            this.checkBox = checkBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.userInput.setValue(this.checkBox.isSelected());
            this.checkBox.setSelected(this.userInput.getValue());
        }
    }
}

