/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver.common;

import com.ur.polyscope.installation.internal.urcapdriver.common.ThreadSafeChangeListener$AjcClosure1;
import com.ur.polyscope.urcaps.ConsoleLoggerExceptionHandler;
import com.ur.polyscope.urcaps.ExceptionHandler;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.urcap.api.contribution.driver.general.userinput.ValueChangedListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ThreadSafeChangeListener<T>
implements ValueChangedListener<T> {
    private static final BlockingQueue<ChangeNotifier> CHANGE_NOTIFIERS;
    private static final Thread EVENT_THREAD;
    private final ValueChangedListener listener;
    private final ExceptionHandler exceptionHandler;
    private final ConsoleLoggerExceptionHandler consoleLoggerExceptionHandler;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        ThreadSafeChangeListener.ajc$preClinit();
        CHANGE_NOTIFIERS = new LinkedBlockingDeque<ChangeNotifier>();
        EVENT_THREAD = new Thread((Runnable)new ValueChangedSender(CHANGE_NOTIFIERS), "ValueChange - Sender");
        EVENT_THREAD.setDaemon(true);
        EVENT_THREAD.start();
    }

    public ThreadSafeChangeListener(ValueChangedListener<T> listener, ExceptionHandler exceptionHandler, ConsoleLoggerExceptionHandler consoleLoggerExceptionHandler) {
        this.listener = listener;
        this.exceptionHandler = exceptionHandler;
        this.consoleLoggerExceptionHandler = consoleLoggerExceptionHandler;
    }

    public void onValueChanged(T value) {
        T t = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, t);
        Object[] objectArray = new Object[]{this, t, joinPoint};
        ThreadSafeChangeListener$AjcClosure1 threadSafeChangeListener$AjcClosure1 = new ThreadSafeChangeListener$AjcClosure1(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(threadSafeChangeListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ void onValueChanged_aroundBody0(ThreadSafeChangeListener ajc$this, Object value, JoinPoint joinPoint) {
        ChangeNotifier<Object> changeNotifier = new ChangeNotifier<Object>(ajc$this.listener, value, ajc$this.exceptionHandler, ajc$this.consoleLoggerExceptionHandler);
        CHANGE_NOTIFIERS.add(changeNotifier);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ThreadSafeChangeListener.java", ThreadSafeChangeListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onValueChanged", "com.ur.polyscope.installation.internal.urcapdriver.common.ThreadSafeChangeListener", "java.lang.Object", "value", "", "void"), 33);
    }

    private static class ChangeNotifier<T> {
        private final ValueChangedListener<T> listener;
        private final T value;
        private final ExceptionHandler exceptionHandler;
        private final ConsoleLoggerExceptionHandler consoleLoggerExceptionHandler;

        public ChangeNotifier(ValueChangedListener<T> listener, T value, ExceptionHandler exceptionHandler, ConsoleLoggerExceptionHandler consoleLoggerExceptionHandler) {
            this.listener = listener;
            this.value = value;
            this.exceptionHandler = exceptionHandler;
            this.consoleLoggerExceptionHandler = consoleLoggerExceptionHandler;
        }

        public void send() {
            try {
                this.listener.onValueChanged(this.value);
            }
            catch (RuntimeException e) {
                this.consoleLoggerExceptionHandler.logToConsole((Throwable)e, this.listener.getClass(), Thread.currentThread().getStackTrace()[1]);
                this.exceptionHandler.handleException((Throwable)e, Thread.currentThread().getStackTrace()[1], this.listener.getClass());
            }
        }
    }

    private static class ValueChangedSender
    implements Runnable {
        private final BlockingQueue<ChangeNotifier> notifiers;
        private volatile boolean shuttingDown;

        public ValueChangedSender(BlockingQueue<ChangeNotifier> notifiers) {
            this.notifiers = notifiers;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    shuttingDown = true;
                }
            });
        }

        @Override
        public void run() {
            while (!this.shuttingDown) {
                try {
                    ChangeNotifier notifier = this.notifiers.take();
                    notifier.send();
                }
                catch (InterruptedException interruptedException) {
                    this.shuttingDown = true;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

