/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver.number;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.installation.internal.urcapdriver.common.Revalidatable;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElement;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElementLayoutStrategy;
import com.ur.polyscope.installation.internal.urcapdriver.number.DoubleInput;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.number.NumberFieldBorderable;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.swing.JComponent;

public class DoubleNumberFieldView
implements ViewElement,
Revalidatable.RevalidateListener {
    private final String label;
    private final DoubleInput userInput;
    private NumberField numberField;

    public DoubleNumberFieldView(ViewElementLayoutStrategy layoutStrategy, String label, String unit, Mode mode, DoubleInput userInput) {
        this.label = label;
        this.userInput = userInput;
        this.numberField = layoutStrategy.createNumberField(new SetDoubleValue(userInput));
        this.init(userInput, unit, mode);
        this.layout(layoutStrategy);
        this.userInput.setRevalidateListener(this);
    }

    private void init(DoubleInput userInput, String unit, Mode mode) {
        this.numberField.setValueConverter(NumberFieldBorderable.DUMMY_CONVERTER);
        this.numberField.setFocusable(false);
        this.numberField.setName(String.valueOf(userInput.id) + ".InstallationNodeView");
        this.numberField.setUnit(unit);
        this.numberField.setMode(mode);
        this.numberField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#0.0###"));
        this.numberField.setErrorValidationStrategy(new ValidationStrategy[]{this.adaptValidator(userInput)});
    }

    private AutoCorrectionRangeDecorator adaptValidator(DoubleInput userInput) {
        DoubleRangeValidator validationStrategy = new DoubleRangeValidator(userInput.getValidator());
        return new AutoCorrectionRangeDecorator((ValidationStrategy)validationStrategy, 0.0, 0.0);
    }

    private void layout(ViewElementLayoutStrategy layoutStrategy) {
        layoutStrategy.add(this.label, (JComponent)this.numberField);
    }

    @Override
    public void update() {
        this.numberField.setValue(this.userInput.getValue());
    }

    protected NumberField getNumberField() {
        return this.numberField;
    }

    @Override
    public void onRevalidate() {
        if (this.numberField.isShowing()) {
            this.numberField.forceValidation();
        }
    }

    private static class DoubleRangeValidator
    implements ValidationStrategy {
        private final InputValidator<Double> validator;

        public DoubleRangeValidator(InputValidator<Double> validator) {
            this.validator = validator;
        }

        public boolean isValid(String valueString) {
            if ((valueString = valueString.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)valueString, (String[])new String[]{".", "-", "-."})) {
                return false;
            }
            try {
                Double.parseDouble(valueString);
            }
            catch (Exception exception) {
                return false;
            }
            return this.validator.isValid((Object)PrimitiveUtils.parseDouble((String)valueString));
        }

        public String getErrorMessage(String valueString) {
            if ((valueString = valueString.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)valueString, (String[])new String[]{".", "-", "-."})) {
                return "";
            }
            try {
                Double.parseDouble(valueString);
            }
            catch (Exception exception) {
                return "Not a Number";
            }
            return this.validator.getMessage((Object)PrimitiveUtils.parseDouble((String)valueString));
        }
    }

    private class SetDoubleValue
    implements ActionListener {
        private final DoubleInput userInput;

        public SetDoubleValue(DoubleInput userInput) {
            this.userInput = userInput;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.userInput.setValue((Double)DoubleNumberFieldView.this.numberField.getValue());
        }
    }
}

