/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver.number;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.installation.internal.urcapdriver.common.Revalidatable;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElement;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElementLayoutStrategy;
import com.ur.polyscope.installation.internal.urcapdriver.number.IntegerInput;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.AutoCorrectionRangeLongDecorator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class IntegerNumberFieldView
implements ViewElement,
Revalidatable.RevalidateListener {
    private final String label;
    private final IntegerInput userInput;
    private NumberField numberField;

    public IntegerNumberFieldView(ViewElementLayoutStrategy layoutStrategy, String label, String unit, Mode mode, IntegerInput userInput) {
        this.label = label;
        this.userInput = userInput;
        this.numberField = layoutStrategy.createNumberField(new SetIntegerValueListener(userInput));
        this.init(userInput.id, unit, mode, userInput);
        this.layout(layoutStrategy);
        this.userInput.setRevalidateListener(this);
    }

    private void init(String id, String unit, Mode mode, IntegerInput userInput) {
        this.numberField.setFocusable(false);
        this.numberField.setName(String.valueOf(id) + ".InstallationNodeView");
        this.numberField.setValueConverter((ValueConverter)ValueConverter.INTEGER_CONVERTER);
        this.numberField.setMode(mode);
        this.numberField.setUnit(unit);
        this.numberField.setErrorValidationStrategy(new ValidationStrategy[]{this.adaptValidator(userInput)});
    }

    private AutoCorrectionRangeLongDecorator adaptValidator(IntegerInput userInput) {
        InputValidator validator = userInput.getValidator();
        IntegerValidationStrategy validationStrategy = new IntegerValidationStrategy(validator, userInput);
        return new AutoCorrectionRangeLongDecorator((ValidationStrategy)validationStrategy, 0L, 0L);
    }

    private void layout(ViewElementLayoutStrategy layoutStrategy) {
        layoutStrategy.add(this.label, (JComponent)this.numberField);
    }

    @Override
    public void update() {
        this.numberField.setValue(this.userInput.getValue());
    }

    @Override
    public void onRevalidate() {
        if (this.numberField.isShowing()) {
            this.numberField.forceValidation();
        }
    }

    protected NumberField getNumberField() {
        return this.numberField;
    }

    private static class IntegerValidationStrategy
    implements ValidationStrategy {
        private final InputValidator<Integer> validator;
        private final IntegerInput userInput;

        public IntegerValidationStrategy(InputValidator<Integer> validator, IntegerInput userInput) {
            this.validator = validator;
            this.userInput = userInput;
        }

        public boolean isValid(String valueString) {
            if ((valueString = valueString.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)valueString, (String[])new String[]{".", "-", "-."})) {
                return false;
            }
            try {
                Integer.parseInt(valueString);
            }
            catch (Exception exception) {
                return false;
            }
            return this.validator.isValid((Object)PrimitiveUtils.parseInteger((String)valueString, (int)((Integer)this.userInput.getDefaultValue())));
        }

        public String getErrorMessage(String valueString) {
            if ((valueString = valueString.replace(',', '.')).isEmpty() || StringUtils.equalsAny((String)valueString, (String[])new String[]{".", "-", "-."})) {
                return "";
            }
            try {
                Integer.parseInt(valueString);
            }
            catch (Exception exception) {
                return "Not a Number";
            }
            return this.validator.getMessage((Object)PrimitiveUtils.parseInteger((String)valueString, (int)((Integer)this.userInput.getDefaultValue())));
        }
    }

    private class SetIntegerValueListener
    implements ActionListener {
        private final IntegerInput userInput;

        public SetIntegerValueListener(IntegerInput userInput) {
            this.userInput = userInput;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.userInput.setValue(PrimitiveUtils.parseInteger((String)IntegerNumberFieldView.this.numberField.getText(), (int)((Integer)this.userInput.getDefaultValue())));
        }
    }
}

