/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver.selection;

import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElement;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElementLayoutStrategy;
import com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxElement;
import com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.RenderingStrategy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;

public class ComboBoxFieldView
implements ViewElement {
    private final ComboBoxInput.ComboBoxInputUserInput userInput;
    private final JComboBox comboBox;

    public ComboBoxFieldView(ViewElementLayoutStrategy layoutStrategy, String label, ComboBoxInput.ComboBoxInputUserInput userInput) {
        this.userInput = userInput;
        this.comboBox = new JComboBox();
        this.init(userInput);
        this.layout(label, layoutStrategy);
        this.addListeners(userInput);
    }

    private void init(ComboBoxInput.ComboBoxInputUserInput userInput) {
        this.comboBox.setFocusable(false);
        this.comboBox.setName(String.valueOf(userInput.getId()) + ".InstallationNodeView");
        this.updateComboBoxModel(userInput);
        ComboBoxElement selectedItem = (ComboBoxElement)userInput.getValue();
        this.comboBox.setSelectedItem(selectedItem);
        ComboBoxRenderer.bindRenderer((JComboBox)this.comboBox, (RenderingStrategy)new RenderingStrategy(){

            public String getText(Object o) {
                if (o instanceof ComboBoxElement) {
                    ComboBoxElement comboBoxElement = (ComboBoxElement)o;
                    return comboBoxElement.getDisplayName();
                }
                return String.valueOf(o);
            }

            public Icon getIcon(Object o) {
                return null;
            }

            public boolean hasError(Object o) {
                if (o instanceof ComboBoxElement) {
                    ComboBoxElement comboBoxElement = (ComboBoxElement)o;
                    return !comboBoxElement.isPlaceholder() && !comboBoxElement.isDefined();
                }
                return false;
            }
        });
    }

    private void updateComboBoxModel(ComboBoxInput.ComboBoxInputUserInput userInput) {
        Object[] values = userInput.getValues();
        this.comboBox.setModel(new DefaultComboBoxModel<Object>(values));
    }

    private void layout(String label, ViewElementLayoutStrategy layoutStrategy) {
        layoutStrategy.add(label, this.comboBox);
    }

    private void addListeners(ComboBoxInput.ComboBoxInputUserInput userInput) {
        this.comboBox.addActionListener(new UpdateDataModelOnSelect(userInput));
    }

    @Override
    public void update() {
        this.updateComboBoxModel(this.userInput);
        this.comboBox.setSelectedItem(this.userInput.getValue());
    }

    private static class UpdateDataModelOnSelect
    implements ActionListener {
        private final ComboBoxInput.ComboBoxInputUserInput userInput;

        public UpdateDataModelOnSelect(ComboBoxInput.ComboBoxInputUserInput userInput) {
            this.userInput = userInput;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            ComboBoxElement selectedItem = (ComboBoxElement)cb.getSelectedItem();
            this.userInput.setValue(selectedItem);
        }
    }
}

