/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver.selection;

import com.ur.polyscope.installation.internal.urcapdriver.common.AbstractUserInput;
import com.ur.polyscope.installation.internal.urcapdriver.common.Deprecateable;
import com.ur.polyscope.installation.internal.urcapdriver.common.HasID;
import com.ur.polyscope.installation.internal.urcapdriver.common.ThreadSafeChangeListener;
import com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxElement;
import com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput$1$AjcClosure1;
import com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput$AjcClosure1;
import com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput$AjcClosure3;
import com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput$NullListener$AjcClosure1;
import com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxModel;
import com.ur.polyscope.urcaps.ConsoleLoggerExceptionHandler;
import com.ur.polyscope.urcaps.ExceptionHandler;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.urcap.api.contribution.driver.general.userinput.CannotAccessDeprecatedUserInput;
import com.ur.urcap.api.contribution.driver.general.userinput.ValueChangedListener;
import com.ur.urcap.api.contribution.driver.general.userinput.selectableinput.DuplicateElementID;
import com.ur.urcap.api.contribution.driver.general.userinput.selectableinput.ElementListCannotBeEmpty;
import com.ur.urcap.api.contribution.driver.general.userinput.selectableinput.ElementResolver;
import com.ur.urcap.api.contribution.driver.general.userinput.selectableinput.InvalidSelection;
import com.ur.urcap.api.contribution.driver.general.userinput.selectableinput.SelectableUserInput;
import com.ur.urcap.api.domain.data.DataModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ComboBoxInput<T>
implements SelectableUserInput<T>,
HasID,
Deprecateable {
    private static final String DISPLAY_NAME = "DisplayName";
    private static final ValueChangedListener NULL_LISTENER;
    private final ComboBoxModel<T> comboBoxModel;
    private final ElementResolver<T> resolver;
    private final ComboBoxInputUserInput userInput;
    private final ExceptionHandler exceptionHandler;
    private final ConsoleLoggerExceptionHandler consoleLoggerExceptionHandler;
    private final ComboBoxElement<T> initialSelection;
    private final ComboBoxElement<T> uninitializedSelection;
    private ValueChangedListener<T> listener = NULL_LISTENER;
    private boolean isDeprecated = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ComboBoxInput.ajc$preClinit();
        NULL_LISTENER = new NullListener();
    }

    public ComboBoxInput(String id, ComboBoxModel<T> comboBoxModel, DataModel dataModel, ExceptionHandler exceptionHandler, ConsoleLoggerExceptionHandler consoleLoggerExceptionHandler) {
        this.comboBoxModel = comboBoxModel;
        this.resolver = comboBoxModel.getResolver();
        this.exceptionHandler = exceptionHandler;
        this.consoleLoggerExceptionHandler = consoleLoggerExceptionHandler;
        T initialSelectionValue = comboBoxModel.getInitialSelection();
        if (initialSelectionValue != null) {
            String initialSelectionId = this.resolver.getId(initialSelectionValue);
            String initialSelectionDisplayName = this.resolver.getDisplayName(initialSelectionValue);
            this.initialSelection = new ComboBoxElement<T>(initialSelectionId, initialSelectionDisplayName, initialSelectionValue);
            this.uninitializedSelection = null;
            this.userInput = new ComboBoxInputUserInput(id, this.initialSelection, dataModel, exceptionHandler, consoleLoggerExceptionHandler);
        } else {
            this.initialSelection = null;
            this.uninitializedSelection = new ComboBoxElement<Object>(null, comboBoxModel.getUninitializedSelection(), null);
            this.userInput = new ComboBoxInputUserInput(id, this.uninitializedSelection, dataModel, exceptionHandler, consoleLoggerExceptionHandler);
        }
        this.userInput.setValueChangedListener(new ValueChangedListener<ComboBoxElement<T>>(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public void onValueChanged(ComboBoxElement<T> value) {
                ComboBoxElement comboBoxElement = value;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, comboBoxElement);
                Object[] objectArray = new Object[]{this, comboBoxElement, joinPoint};
                ComboBoxInput$1$AjcClosure1 comboBoxInput$1$AjcClosure1 = new ComboBoxInput$1$AjcClosure1(objectArray);
                UncaughtExceptionAspect.aspectOf().aroundMethod(comboBoxInput$1$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                1.ajc$preClinit();
            }

            static final /* synthetic */ void onValueChanged_aroundBody0(1 ajc$this, ComboBoxElement value, JoinPoint joinPoint) {
                ajc$this.ComboBoxInput.this.listener.onValueChanged(value.getValue());
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("ComboBoxInput.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onValueChanged", "com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput$1", "com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxElement", "value", "", "void"), 63);
            }
        });
    }

    @Override
    public String getId() {
        return this.userInput.getId();
    }

    @Override
    public String getModelId() {
        return this.userInput.getModelId();
    }

    @Override
    public void deprecate() {
        this.isDeprecated = true;
    }

    public T getValue() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ComboBoxInput$AjcClosure1 comboBoxInput$AjcClosure1 = new ComboBoxInput$AjcClosure1(objectArray);
        return (T)UncaughtExceptionAspect.aspectOf().aroundMethod(comboBoxInput$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void setValueChangedListener(ValueChangedListener<T> listener) {
        ValueChangedListener<T> valueChangedListener = listener;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, valueChangedListener);
        Object[] objectArray = new Object[]{this, valueChangedListener, joinPoint};
        ComboBoxInput$AjcClosure3 comboBoxInput$AjcClosure3 = new ComboBoxInput$AjcClosure3(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(comboBoxInput$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public ComboBoxInputUserInput getUserInput() {
        return this.userInput;
    }

    public static <T> void checkComboBoxModel(String id, ComboBoxModel<T> model) {
        if (model.getList().isEmpty()) {
            throw new ElementListCannotBeEmpty(String.format("Trying to register '%s' with an empty list of elements", id));
        }
        ElementResolver<T> resolver = model.getResolver();
        Set<String> ids = ComboBoxInput.getIds(model.getList(), resolver);
        T initialSelection = model.getInitialSelection();
        if (initialSelection != null) {
            ComboBoxInput.ensureInitialValueContained(resolver.getId(initialSelection), ids);
        }
    }

    private static void ensureInitialValueContained(String initialId, Set<String> ids) {
        if (!ids.contains(initialId)) {
            throw new InvalidSelection(String.format("Initial selection element with id `%s` was not found in the list of the elements to be selectable in the combo box.", initialId));
        }
    }

    private static <T> Set<String> getIds(List<T> values, ElementResolver<T> resolver) {
        HashSet<String> ids = new HashSet<String>();
        for (T each : values) {
            if (ids.add(resolver.getId(each))) continue;
            throw new DuplicateElementID(String.format("Several elements resolved to the same `%s` id.", resolver.getId(each)));
        }
        return ids;
    }

    static final /* synthetic */ Object getValue_aroundBody0(ComboBoxInput ajc$this, JoinPoint joinPoint) {
        if (ajc$this.isDeprecated) {
            throw new CannotAccessDeprecatedUserInput("Do not access a deprecated user input. Use the return value of deprecateUserInput() instead.");
        }
        ComboBoxElement selected = (ComboBoxElement)ajc$this.userInput.getValue();
        return selected.getValue();
    }

    static final /* synthetic */ void setValueChangedListener_aroundBody2(ComboBoxInput ajc$this, ValueChangedListener listener, JoinPoint joinPoint) {
        ajc$this.listener = listener != null ? new ThreadSafeChangeListener(listener, ajc$this.exceptionHandler, ajc$this.consoleLoggerExceptionHandler) : NULL_LISTENER;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ComboBoxInput.java", ComboBoxInput.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValue", "com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput", "", "", "", "java.lang.Object"), 85);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setValueChangedListener", "com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput", "com.ur.urcap.api.contribution.driver.general.userinput.ValueChangedListener", "listener", "", "void"), 94);
    }

    public final class ComboBoxInputUserInput
    extends AbstractUserInput<ComboBoxElement<T>> {
        private ComboBoxInputUserInput(String id, ComboBoxElement<T> defaultValue, DataModel model, ExceptionHandler exceptionHandler, ConsoleLoggerExceptionHandler consoleLoggerExceptionHandler) {
            super(id, defaultValue, model, exceptionHandler, consoleLoggerExceptionHandler);
        }

        @Override
        protected String postfixModelId() {
            return "_select";
        }

        @Override
        public void doSetValue(ComboBoxElement<T> value) {
            DataModel model = this.getModel();
            if (value == null || value.isPlaceholder()) {
                model.remove(super.getModelId());
                model.remove(String.valueOf(super.getModelId()) + ComboBoxInput.DISPLAY_NAME);
                return;
            }
            model.set(super.getModelId(), value.getId());
            model.set(String.valueOf(super.getModelId()) + ComboBoxInput.DISPLAY_NAME, value.getDisplayName());
        }

        @Override
        public ComboBoxElement<T> getDefaultValue() {
            if (ComboBoxInput.this.initialSelection != null) {
                return ComboBoxInput.this.initialSelection;
            }
            return ComboBoxInput.this.uninitializedSelection;
        }

        public ComboBoxElement<T> getValueById(String selectionId) {
            List values = ComboBoxInput.this.comboBoxModel.getList();
            for (Object value : values) {
                if (!selectionId.equals(ComboBoxInput.this.resolver.getId(value))) continue;
                String selectionDisplayName = ComboBoxInput.this.resolver.getDisplayName(value);
                return new ComboBoxElement(selectionId, selectionDisplayName, value);
            }
            return null;
        }

        @Override
        protected ComboBoxElement<T> doGetValue() {
            String selectionId = this.getSelectedId();
            if (selectionId == null) {
                return this.getDefaultValue();
            }
            ComboBoxElement<Object> selected = this.getValueById(selectionId);
            if (selected == null) {
                String selectionDisplayName = this.getModel().get(String.valueOf(super.getModelId()) + ComboBoxInput.DISPLAY_NAME, "");
                selected = new ComboBoxElement<Object>(selectionId, selectionDisplayName, null);
            }
            return selected;
        }

        private String getSelectedId() {
            String defaultId = null;
            if (ComboBoxInput.this.initialSelection != null) {
                defaultId = ComboBoxInput.this.initialSelection.getId();
            }
            return this.getModel().get(super.getModelId(), defaultId);
        }

        public Object[] getValues() {
            ArrayList list = new ArrayList();
            ComboBoxElement selected = (ComboBoxElement)this.getValue();
            if (!selected.isPlaceholder() && !selected.isDefined()) {
                list.add(selected);
            }
            if (ComboBoxInput.this.uninitializedSelection != null) {
                list.add(ComboBoxInput.this.uninitializedSelection);
            }
            List values = ComboBoxInput.this.comboBoxModel.getList();
            for (Object value : values) {
                String elementId = ComboBoxInput.this.resolver.getId(value);
                String elementDisplayName = ComboBoxInput.this.resolver.getDisplayName(value);
                list.add(new ComboBoxElement(elementId, elementDisplayName, value));
            }
            return list.toArray();
        }

        @Override
        public boolean isDefined() {
            if (ComboBoxInput.this.isDeprecated) {
                return true;
            }
            ComboBoxElement selected = (ComboBoxElement)this.getValue();
            return selected.isDefined();
        }
    }

    private static class NullListener
    implements ValueChangedListener {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private NullListener() {
        }

        public void onValueChanged(Object value) {
            Object object = value;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)object);
            Object[] objectArray = new Object[]{this, object, joinPoint};
            ComboBoxInput$NullListener$AjcClosure1 comboBoxInput$NullListener$AjcClosure1 = new ComboBoxInput$NullListener$AjcClosure1(objectArray);
            UncaughtExceptionAspect.aspectOf().aroundMethod(comboBoxInput$NullListener$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        static {
            NullListener.ajc$preClinit();
        }

        static final /* synthetic */ void onValueChanged_aroundBody0(NullListener ajc$this, Object value, JoinPoint joinPoint) {
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ComboBoxInput.java", NullListener.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onValueChanged", "com.ur.polyscope.installation.internal.urcapdriver.selection.ComboBoxInput$NullListener", "java.lang.Object", "value", "", "void"), 232);
        }
    }
}

