/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver.string;

import com.ur.polyscope.installation.internal.urcapdriver.common.Revalidatable;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElement;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElementLayoutStrategy;
import com.ur.polyscope.installation.internal.urcapdriver.string.StringInput;
import com.ur.polyscope.installation.internal.urcapdriver.string.WrappedValidator;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class IpAddressNumberFieldView
implements ViewElement,
Revalidatable.RevalidateListener {
    private final NumberField numberField;
    private final String label;
    private final StringInput input;

    public IpAddressNumberFieldView(ViewElementLayoutStrategy layoutStrategy, String label, StringInput input) {
        this.label = label;
        this.input = input;
        this.numberField = layoutStrategy.createNumberField(new SetIpAddressValueListener(input));
        this.init(input.id);
        this.layout(layoutStrategy);
        this.input.setRevalidateListener(this);
    }

    private void init(String id) {
        this.numberField.setFocusable(false);
        this.numberField.setName(String.valueOf(id) + ".InstallationNodeView");
        this.numberField.setMode(Mode.IP_ADDRESS);
        this.numberField.setErrorValidationStrategy(new ValidationStrategy[]{this.adaptValidator(this.input.getValidator())});
    }

    private AutoCorrectionRangeDecorator adaptValidator(InputValidator<String> validator) {
        WrappedValidator validationStrategy = new WrappedValidator(validator);
        return new AutoCorrectionRangeDecorator((ValidationStrategy)validationStrategy, 0.0, 0.0);
    }

    private void layout(ViewElementLayoutStrategy layoutStrategy) {
        layoutStrategy.add(this.label, (JComponent)this.numberField);
    }

    @Override
    public void update() {
        this.numberField.setText((String)this.input.getValue());
    }

    @Override
    public void onRevalidate() {
        if (this.numberField.isShowing()) {
            this.numberField.forceValidation();
        }
    }

    private class SetIpAddressValueListener
    implements ActionListener {
        private final StringInput userInput;

        public SetIpAddressValueListener(StringInput userInput) {
            this.userInput = userInput;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.userInput.setValue(IpAddressNumberFieldView.this.numberField.getText());
        }
    }
}

