/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver.string;

import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElement;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElementLayoutStrategy;
import com.ur.polyscope.installation.internal.urcapdriver.string.TextComponentImpl;
import javax.swing.Icon;
import javax.swing.JLabel;

public class LabelView
implements ViewElement {
    private JLabel widget;

    public LabelView(ViewElementLayoutStrategy layoutStrategy, TextComponentImpl text) {
        this.init(layoutStrategy, text);
        this.addListeners(text);
    }

    private void init(ViewElementLayoutStrategy layoutStrategy, TextComponentImpl text) {
        this.widget = layoutStrategy.createLabel(text.getText(), text.getIcon());
        layoutStrategy.add(text.getLabel(), this.widget);
    }

    private void addListeners(TextComponentImpl text) {
        text.setChangeListener(new UpdateTextOnChange(this.widget));
    }

    @Override
    public void update() {
    }

    private static class UpdateTextOnChange
    extends TextComponentImpl.ChangeListener {
        private final JLabel widget;

        public UpdateTextOnChange(JLabel widget) {
            this.widget = widget;
        }

        @Override
        public void onTextChange(String text) {
            this.widget.setText(text);
        }

        @Override
        public void onIconChange(Icon icon) {
            this.widget.setIcon(icon);
        }
    }
}

