/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.urcapdriver.string;

import com.ur.polyscope.installation.internal.urcapdriver.common.Revalidatable;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElement;
import com.ur.polyscope.installation.internal.urcapdriver.common.ViewElementLayoutStrategy;
import com.ur.polyscope.installation.internal.urcapdriver.string.StringInput;
import com.ur.swing.validation.ValidationDocumentListener;
import com.ur.swing.validation.ValidationStrategy;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class TextFieldView
implements ViewElement,
Revalidatable.RevalidateListener {
    private final String label;
    private final StringInput userInput;
    private final ValidationDocumentListener validationListener;
    private final JTextField textField;

    public TextFieldView(ViewElementLayoutStrategy layoutStrategy, String label, StringInput userInput) {
        this.label = label;
        this.userInput = userInput;
        this.textField = layoutStrategy.createTextField(userInput);
        this.validationListener = new ValidationDocumentListener((JTextComponent)this.textField, new ValidationStrategy(){

            public boolean isValid(String s) {
                return TextFieldView.this.userInput.getValidator().isValid((Object)s);
            }

            public String getErrorMessage(String s) {
                return TextFieldView.this.userInput.getValidator().getMessage((Object)s);
            }
        });
        this.init(userInput.id);
        this.layout(layoutStrategy);
        userInput.setRevalidateListener(this);
    }

    private void init(String id) {
        this.textField.setFocusable(false);
        this.textField.setName(String.valueOf(id) + ".InstallationNodeView");
        this.textField.getDocument().addDocumentListener((DocumentListener)this.validationListener);
    }

    private void layout(ViewElementLayoutStrategy layoutStrategy) {
        layoutStrategy.add(this.label, this.textField);
    }

    @Override
    public void update() {
        this.textField.setText((String)this.userInput.getValue());
    }

    @Override
    public void onRevalidate() {
        if (this.textField.isShowing()) {
            this.validationListener.update();
        }
    }
}

