/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.java.logger.internal;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.internal.LogLevelConverter;
import com.ur.polyscope.java.logger.internal.Settings;
import com.ur.polyscope.java.logger.internal.log4j2.BridgeForOldLogger;
import com.ur.polyscope.java.logger.internal.log4j2.InternalLogFactory;
import com.ur.util.logging.Log;
import com.ur.util.logging.LogStrategy;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.osgi.BundleContextSelector;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public void start(BundleContext bundleContext) {
        this.initializeLog4j();
        this.initializeLegacyLogging();
    }

    private void initializeLegacyLogging() {
        Log.setLogStrategy((LogStrategy)new BridgeForOldLogger());
        Log.setLoggingLevel((Log.Level)LogLevelConverter.convertFromLog4j2(LogManager.getLogger().getLevel()));
    }

    private void initializeLog4j() {
        Settings settings = new Settings();
        settings.writeDefaultSettings();
        System.setProperty("org.apache.logging.log4j.simplelog.StatusLogger.level", Level.OFF.name());
        System.setProperty("log4j.configurationFile", settings.getLogConfiguration());
        LogManager.setFactory((LoggerContextFactory)new Log4jContextFactory((ContextSelector)new BundleContextSelector()));
        LogFactory.setLogFactory((LogFactory)new InternalLogFactory());
    }

    public void stop(BundleContext bundleContext) {
    }
}

