/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.java.logger.internal;

import com.ur.lang.StreamUtils;
import com.ur.polyscope.java.logger.internal.ResetXmlSettings;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.InputStream;

class Settings {
    private static final String DEFAULT_LOG_SETTINGS = "/default-settings/default-log-parameters.xml";
    private static final String HOME_DIRECTORY = System.getProperty("user.home");
    private static final File POLYSCOPE_PATH = new File(HOME_DIRECTORY, ".polyscope");
    private final File logConfiguration = new File(POLYSCOPE_PATH, "java-logger.xml");

    Settings() {
    }

    String getLogConfiguration() {
        return this.logConfiguration.getPath();
    }

    void writeDefaultSettings() {
        if (!this.logConfiguration.exists() || this.overwriteConfigFile()) {
            InputStream resource = this.getResourceAsStream(DEFAULT_LOG_SETTINGS);
            FileUtils.writeToFile((String)StreamUtils.readFromStream((InputStream)resource, (String)""), (File)this.logConfiguration);
        }
    }

    private InputStream getResourceAsStream(String file) {
        return this.getClass().getClassLoader().getResourceAsStream(file);
    }

    private boolean overwriteConfigFile() {
        return ResetXmlSettings.resetXML();
    }
}

