/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.java.logger.internal.log4j2;

import com.ur.lang.StringUtils;
import com.ur.lang.fuzzy.FuzzyMatch;
import com.ur.polyscope.java.logger.Level;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.java.logger.internal.log4j2.AutoTraceLogger;
import com.ur.polyscope.java.logger.internal.log4j2.Configuration;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class LoggerWrapper
implements Logger,
AutoTraceLogger {
    private static final int MAX_STRING_LENGTH = Configuration.maxStringLengthForFuzzyMatch();
    private static final float FUZZY_MATCH_SCORE = Configuration.fuzzyMatchScore();
    private static long fuzzyMatchTraceResetTimeout = 5000L;
    private static boolean allowDuplicates = Boolean.parseBoolean(System.getenv("ALLOW_DUPLICATE_TRACE_ROUTES"));
    static final Marker TRACE_ROUTE = MarkerManager.getMarker((String)"TRACE_ROUTE");
    private final org.apache.logging.log4j.Logger log4jLogger;
    private Object lastTrace;
    private long lastTraceTime;

    public LoggerWrapper(org.apache.logging.log4j.Logger log4jLogger) {
        this.log4jLogger = log4jLogger;
    }

    static void setAllowDuplicates(boolean newValue) {
        allowDuplicates = newValue;
    }

    public static void setTraceRouteFuzzyMatchTimeout(long timeout) {
        fuzzyMatchTraceResetTimeout = timeout;
    }

    public Level getLevel() {
        return this.convertFromLog4j2(this.log4jLogger.getLevel());
    }

    public String getName() {
        return this.log4jLogger.getName();
    }

    @Override
    public void entry() {
        this.log4jLogger.entry();
    }

    @Override
    public void entry(Object ... params) {
        this.log4jLogger.entry(params);
    }

    @Override
    public void exit() {
        this.log4jLogger.exit();
    }

    @Override
    public <R> R exit(R result) {
        return (R)this.log4jLogger.exit(result);
    }

    @Override
    public <T extends Throwable> T throwing(T t) {
        return (T)this.log4jLogger.throwing(t);
    }

    public boolean isLogLevelEnabled(Level logLevel) {
        return this.log4jLogger.isEnabled(this.convertToLog4j2(logLevel));
    }

    public void fatal(String message, Object ... params) {
        this.log4jLogger.fatal(message, params);
    }

    public void fatal(String message, Throwable t) {
        this.log4jLogger.fatal(message, t);
    }

    public void error(String message, Object ... params) {
        this.log4jLogger.error(message, params);
    }

    public void error(String message, Throwable t) {
        this.log4jLogger.error(message, t);
    }

    public void warn(String message, Object ... params) {
        this.log4jLogger.warn(message, params);
    }

    public void warn(String message, Throwable t) {
        this.log4jLogger.warn(message, t);
    }

    public void info(String message, Object ... params) {
        this.log4jLogger.info(message, params);
    }

    public void info(String message, Throwable t) {
        this.log4jLogger.info(message, t);
    }

    public void debug(String message, Object ... params) {
        this.log4jLogger.debug(message, params);
    }

    public void debug(String message, Throwable t) {
        this.log4jLogger.debug(message, t);
    }

    public void trace(String message, Object ... params) {
        this.log4jLogger.trace(message, params);
    }

    public void trace(String message, Throwable t) {
        this.log4jLogger.trace(message, t);
    }

    public void traceRoute(Object message) {
        if (allowDuplicates || !this.isFuzzyMatch(message)) {
            this.lastTrace = message;
            this.lastTraceTime = System.currentTimeMillis();
            this.log4jLogger.info(TRACE_ROUTE, message);
        }
    }

    private boolean isFuzzyMatch(Object object) {
        if (System.currentTimeMillis() - this.lastTraceTime > fuzzyMatchTraceResetTimeout) {
            return false;
        }
        return FuzzyMatch.matchScore((String)StringUtils.toString((Object)this.lastTrace), (String)StringUtils.toString((Object)object), (int)MAX_STRING_LENGTH) > (double)FUZZY_MATCH_SCORE;
    }

    private Level convertFromLog4j2(org.apache.logging.log4j.Level log4Jlevel) {
        return Level.valueOf((String)log4Jlevel.getStandardLevel().name());
    }

    private org.apache.logging.log4j.Level convertToLog4j2(Level polyscopeLogLevel) {
        return org.apache.logging.log4j.Level.valueOf((String)polyscopeLogLevel.name());
    }
}

