/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl;

import com.google.inject.TypeLiteral;
import com.ur.dashboardserver.DashBoardAction;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ServicesBinder;
import com.ur.lang.react.Recipe;
import com.ur.polyscope.security.GoToEnterPassword;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.PrivilegeRestrictionStrategy;
import com.ur.polyscope.security.PrivilegeStrategy;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.UserAccessState;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.security.impl.accessmode.AccessModeManager;
import com.ur.polyscope.security.impl.accessmode.AccessModeSettings;
import com.ur.polyscope.security.impl.accessmode.SyncAccessModeService;
import com.ur.polyscope.security.impl.accessmode.impl.AccessModeServiceImpl;
import com.ur.polyscope.security.impl.accessmode.impl.AccessModeSettingsImpl;
import com.ur.polyscope.security.impl.accessmode.impl.MonitorURAdminStateChanged;
import com.ur.polyscope.security.impl.accessmode.impl.SyncAccessModeDashboardAction;
import com.ur.polyscope.security.impl.accessmode.impl.WatcherPath;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.SecuritySettingsListener;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.AdminLockImpl;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.view.RequireAdminPasswordFooterImpl;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.view.SetAdminActionPanelDefinition;
import com.ur.polyscope.security.impl.cybersecurity.data.AccessModeRepositoryImpl;
import com.ur.polyscope.security.impl.cybersecurity.data.GeneralSecurityRepositoryImpl;
import com.ur.polyscope.security.impl.cybersecurity.data.SecureShellRepositoryImpl;
import com.ur.polyscope.security.impl.cybersecurity.data.ServicesRepositoryImpl;
import com.ur.polyscope.security.impl.cybersecurity.data.SimulatedSecurityService;
import com.ur.polyscope.security.impl.cybersecurity.data.URAdminSecurityService;
import com.ur.polyscope.security.impl.cybersecurity.service.GeneralSecurityRepository;
import com.ur.polyscope.security.impl.cybersecurity.service.SecureShellRepository;
import com.ur.polyscope.security.impl.cybersecurity.service.SecurityService;
import com.ur.polyscope.security.impl.cybersecurity.service.ServicesRepository;
import com.ur.polyscope.security.impl.cybersecurity.ui.GeneralSettingsActionDefinition;
import com.ur.polyscope.security.impl.cybersecurity.ui.SecureShellActionDefinition;
import com.ur.polyscope.security.impl.cybersecurity.ui.ServicesSettingsActionDefinition;
import com.ur.polyscope.security.impl.privilege.LockEnablingActionCreator;
import com.ur.polyscope.security.impl.roles.AccessControlPasswordUpdateListener;
import com.ur.polyscope.security.impl.roles.AccessModeStatusDashboardAction;
import com.ur.polyscope.security.impl.roles.OperationalModeClearDashboardAction;
import com.ur.polyscope.security.impl.roles.OperationalModeDashboardAction;
import com.ur.polyscope.security.impl.roles.OperationalModeStatusDashboardAction;
import com.ur.polyscope.security.impl.roles.Settings;
import com.ur.polyscope.security.impl.roles.UserAccessControlImpl;
import com.ur.polyscope.security.impl.roles.UserProfileSettings;
import com.ur.polyscope.security.impl.useraccess.EnterAdminPasswordPanel;
import com.ur.polyscope.security.impl.useraccess.EnterGeneralPasswordPanel;
import com.ur.polyscope.security.impl.useraccess.EnterGeneralWhenEnteringPasswordPanel;
import com.ur.polyscope.security.impl.useraccess.EnterHardcodedPasswordPanel;
import com.ur.polyscope.security.impl.useraccess.EnterSafetyPasswordPanel;
import com.ur.polyscope.security.impl.useraccess.GoToEnterPasswordImpl;
import com.ur.polyscope.security.impl.useraccess.OperationalModeActionPanelDefinition;
import com.ur.polyscope.security.impl.useraccess.PasswordFactory;
import com.ur.polyscope.security.impl.useraccess.PasswordManagerImpl;
import com.ur.polyscope.security.impl.useraccess.PasswordObjectFactory;
import com.ur.polyscope.security.impl.useraccess.SafetyActionPanelDefinition;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.polyscope.security.internal.impl.TextResourceImpl;
import com.ur.polyscope.settings.SettingsListener;
import com.ur.swing.CardPanel;
import com.ur.swing.CardPanelMappedContribution;
import com.ur.swing.platform.ActionPanelDefinition;
import com.ur.swing.platform.SetupSite;
import java.util.HashMap;

public class ServiceBinderImpl
implements ServicesBinder {
    private static final String MOCK_CYBERSECURITY_BACKEND_PROPERTY = "mockCybersecurityBackend";

    public void bind(Binder binder) {
        binder.bindClass(PasswordManager.class, PasswordManagerImpl.class);
        binder.bindClass(RequireAdminPasswordFooter.class, RequireAdminPasswordFooterImpl.class);
        binder.bindClass(AdminLock.class, AdminLockImpl.class);
        binder.bindToExtensionPoint(PrivilegeStrategy.class, Privileges.PlaceHolderStrategy.class);
        binder.bindClass(PasswordObjectFactory.class, PasswordFactory.class);
        binder.bindClass(TextResource.class, TextResourceImpl.class);
        binder.bindClass(UserAccessControl.class, UserAccessControlImpl.class);
        binder.bindClass(GoToEnterPassword.class, GoToEnterPasswordImpl.class);
        binder.bindToExtensionPoint(CardPanelMappedContribution.class, this::getCardPanelContributionMap);
        binder.bindToExtensionPoint(CardPanel.class, EnterSafetyPasswordPanel.class);
        binder.bindToExtensionPoint(CardPanel.class, EnterGeneralPasswordPanel.class);
        binder.bindToExtensionPoint(CardPanel.class, EnterAdminPasswordPanel.class);
        binder.bindToExtensionPoint(CardPanel.class, EnterGeneralWhenEnteringPasswordPanel.class);
        binder.bindToExtensionPoint(CardPanel.class, EnterHardcodedPasswordPanel.class);
        binder.bindClass(UserProfileSettings.class, Settings.class);
        binder.bindToExtensionPoint(PrivilegeStrategy.class, PrivilegeRestrictionStrategy.LockablePrivilegeLevelStrategy.class);
        binder.bindClass(LockActionCreator.class, LockEnablingActionCreator.class);
        binder.bindToExtensionPoint(DashBoardAction.class, OperationalModeDashboardAction.class);
        binder.bindToExtensionPoint(DashBoardAction.class, OperationalModeClearDashboardAction.class);
        binder.bindToExtensionPoint(DashBoardAction.class, AccessModeStatusDashboardAction.class);
        binder.bindToExtensionPoint(DashBoardAction.class, OperationalModeStatusDashboardAction.class);
        binder.bindClass(ServicesRepository.class, ServicesRepositoryImpl.class);
        binder.bindClass(GeneralSecurityRepository.class, GeneralSecurityRepositoryImpl.class);
        binder.bindClass(SecureShellRepository.class, SecureShellRepositoryImpl.class);
        binder.bindClass(AccessModeManager.class, AccessModeRepositoryImpl.class);
        if (ServiceBinderImpl.useMockCyberSecurityToURAdmin()) {
            binder.bindClass(SecurityService.class, SimulatedSecurityService.class);
        } else {
            binder.bindClass(SecurityService.class, URAdminSecurityService.class);
        }
        binder.bindInstance(WatcherPath.class, (Object)new WatcherPath.URToolsPath());
        binder.bindToExtensionPoint(SettingsListener.class, SecuritySettingsListener.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<UserAccessState>>(){}, UserAccessControlImpl.class);
        binder.bindClass(AccessModeSettings.class, AccessModeSettingsImpl.class);
        binder.bindClass(AccessModeService.class, AccessModeServiceImpl.class);
        binder.bindClass(SyncAccessModeService.class, AccessModeServiceImpl.class);
        binder.bindToExtensionPoint(DashBoardAction.class, SyncAccessModeDashboardAction.class);
    }

    private HashMap<Class<? extends CardPanel>, Class<? extends CardPanel>> getCardPanelContributionMap() {
        HashMap<Class<? extends CardPanel>, Class<? extends CardPanel>> cardPanelContributionMap = new HashMap<Class<? extends CardPanel>, Class<? extends CardPanel>>();
        cardPanelContributionMap.put(EnterSafetyPasswordPanel.class, EnterSafetyPasswordPanel.class);
        cardPanelContributionMap.put(EnterGeneralPasswordPanel.class, EnterGeneralPasswordPanel.class);
        cardPanelContributionMap.put(EnterAdminPasswordPanel.class, EnterAdminPasswordPanel.class);
        cardPanelContributionMap.put(EnterHardcodedPasswordPanel.class, EnterHardcodedPasswordPanel.class);
        cardPanelContributionMap.put(EnterGeneralWhenEnteringPasswordPanel.class, EnterGeneralWhenEnteringPasswordPanel.class);
        return cardPanelContributionMap;
    }

    public void load(Builder builder) {
        builder.get(AccessModeService.class);
        builder.get(AccessControlPasswordUpdateListener.class);
        if (!ServiceBinderImpl.useMockCyberSecurityToURAdmin()) {
            ((MonitorURAdminStateChanged)builder.get(MonitorURAdminStateChanged.class)).startMonitor();
        }
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(OperationalModeActionPanelDefinition.class));
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(SafetyActionPanelDefinition.class));
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(SetAdminActionPanelDefinition.class));
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(GeneralSettingsActionDefinition.class));
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(ServicesSettingsActionDefinition.class));
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(SecureShellActionDefinition.class));
    }

    private static boolean useMockCyberSecurityToURAdmin() {
        return Boolean.parseBoolean(System.getProperty(MOCK_CYBERSECURITY_BACKEND_PROPERTY, "false"));
    }
}

