/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.accessmode.impl;

import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.accessmode.AccessMode;
import com.ur.polyscope.security.accessmode.AccessModeChangedListener;
import com.ur.polyscope.security.accessmode.AccessModeNotAllowedException;
import com.ur.polyscope.security.accessmode.AccessModeService;
import com.ur.polyscope.security.impl.accessmode.AccessModeManager;
import com.ur.polyscope.security.impl.accessmode.AccessModeSettings;
import com.ur.polyscope.security.impl.accessmode.SyncAccessModeService;
import com.ur.polyscope.security.impl.accessmode.impl.PrivilegeChangeAdapter;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.OperationalMode;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AccessModeServiceImpl
implements AccessModeService,
SyncAccessModeService {
    private final EventManager eventManager;
    private final UserAccessControl userAccessControl;
    private final AccessModeSettings accessModeSettings;
    private final AccessModeManager accessModeManager;
    private AccessMode accessMode;

    @Inject
    public AccessModeServiceImpl(EventManager eventManager, UserAccessControl userAccessControl, AccessModeSettings accessModeSettings, AccessModeManager accessModeManager) {
        this.eventManager = eventManager;
        this.userAccessControl = userAccessControl;
        this.accessModeSettings = accessModeSettings;
        this.accessModeManager = accessModeManager;
        new PrivilegeChangeAdapter(eventManager, userAccessControl);
    }

    public AccessMode getAccessMode() {
        if (this.accessMode == null) {
            this.accessMode = this.getAccessModeFromManager();
        }
        return this.accessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        try {
            this.doSetAccessMode(accessMode);
        }
        catch (AccessModeNotAllowedException e) {
            Log.info((String)("Access mode not allowed: " + e.getMessage()));
        }
    }

    public boolean isRemoteControlFeatureEnabled() {
        return this.accessModeSettings.isRemoteControlFeatureEnabled();
    }

    public void setRemoteControlFeatureEnabled(boolean enabled) {
        this.accessModeSettings.setRemoteControlFeatureEnabled(enabled);
    }

    private void doSetAccessMode(AccessMode accessMode) throws AccessModeNotAllowedException {
        if (accessMode != this.getAccessMode()) {
            switch (accessMode) {
                case LOCAL: {
                    this.setAccessModeLocal();
                    break;
                }
                case REMOTE: {
                    this.setAccessModeRemote();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported Access mode");
                }
            }
        }
    }

    private void setAccessModeLocal() {
        this.setRemoteControlMode(AccessMode.LOCAL);
    }

    private void setAccessModeRemote() {
        if (!this.isRemoteControlAllowed()) {
            String message = "Access mode REMOTE is not allowed. Operational mode is " + this.userAccessControl.getCurrentOperationalMode();
            throw new AccessModeNotAllowedException(message);
        }
        this.setRemoteControlMode(AccessMode.REMOTE);
    }

    private void setRemoteControlMode(AccessMode accessMode) {
        if (!this.accessModeManager.setRemoteControlActive(accessMode == AccessMode.REMOTE)) {
            return;
        }
        this.accessMode = accessMode;
        this.fireAccessModeChanged();
    }

    private void fireAccessModeChanged() {
        this.eventManager.fireEvent(AccessModeChangedListener.class, listener -> listener.accessModeChanged(this.getAccessMode()));
    }

    protected boolean isRemoteControlAllowed() {
        return !this.isOperationalModeManual();
    }

    private boolean isOperationalModeManual() {
        return this.userAccessControl.getCurrentOperationalModeSource() != OperationalModeSource.NONE && this.userAccessControl.getCurrentOperationalMode() == OperationalMode.MANUAL;
    }

    @Override
    public void syncAccessMode() throws AccessModeNotAllowedException {
        AccessMode accessModeFromManager = this.getAccessModeFromManager();
        this.doSetAccessMode(accessModeFromManager);
    }

    private AccessMode getAccessModeFromManager() {
        return this.accessModeManager.isRemoteControlActive() ? AccessMode.REMOTE : AccessMode.LOCAL;
    }
}

