/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.accessmode.impl;

import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.security.impl.accessmode.AccessModeSettings;
import com.ur.util.logging.Log;
import java.io.IOException;
import javax.inject.Singleton;

@Singleton
public class AccessModeSettingsImpl
implements AccessModeSettings {
    static final String REMOTE_CONTROL_PROPERTIES = "remotecontrol.properties";
    static final String REMOTE_CONTROL_FEATURE_ENABLED = "RemoteControlEnabled";
    private final WriteableModuleSettings settings = new WriteableModuleSettings("remotecontrol.properties");

    @Override
    public boolean isRemoteControlFeatureEnabled() {
        return this.settings.properties().getBoolean(REMOTE_CONTROL_FEATURE_ENABLED, false);
    }

    @Override
    public void setRemoteControlFeatureEnabled(boolean enabled) {
        this.settings.properties().setProperty(REMOTE_CONTROL_FEATURE_ENABLED, Boolean.toString(enabled));
        try {
            this.settings.write();
        }
        catch (IOException e) {
            Log.error((String)"Failed to remote control feature setting: ", (Throwable)e);
        }
    }
}

