/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.accessmode.impl;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.security.impl.accessmode.SyncAccessModeService;
import com.ur.polyscope.security.impl.accessmode.impl.WatcherPath;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MonitorURAdminStateChanged {
    private static final Logger LOGGER = LogFactory.createLogger(MonitorURAdminStateChanged.class);
    private static final String STATE_JSON = "state.json";
    final Thread monitor = new Thread(this::processEvents);
    private final WatchService watcher;
    private final SyncAccessModeService syncAccessModeService;

    @Inject
    MonitorURAdminStateChanged(SyncAccessModeService syncAccessModeService, WatcherPath path) throws IOException {
        this.syncAccessModeService = syncAccessModeService;
        this.watcher = FileSystems.getDefault().newWatchService();
        path.getPath().register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public void startMonitor() {
        this.monitor.setName("URAdmin-state-monitor");
        this.monitor.setDaemon(true);
        this.monitor.start();
    }

    public void shutdown() {
        try {
            this.monitor.interrupt();
            this.watcher.close();
        }
        catch (IOException e) {
            LOGGER.error("Error closing watcher", (Throwable)e);
        }
    }

    private void processEvents() {
        WatchKey key;
        boolean valid;
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
                return;
            }
            key.pollEvents().stream().filter(e -> e.kind() != StandardWatchEventKinds.OVERFLOW).map(WatchEvent::context).filter(p -> p.toString().equals(STATE_JSON)).findFirst().ifPresent(p -> this.syncAccessModeService.syncAccessMode());
        } while (valid = key.reset());
    }
}

