/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.accessmode.impl;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.polyscope.security.accessmode.AccessModeNotAllowedException;
import com.ur.polyscope.security.impl.accessmode.SyncAccessModeService;
import com.ur.util.logging.Log;
import javax.inject.Inject;

@ReadOnlyDashboardAction
public class SyncAccessModeDashboardAction
implements DashBoardAction {
    protected static final String RESULT_OK = "OK";
    protected static final String RESULT_ERROR = "command is not allowed";
    protected static final String COMMAND = "sync accessmode";
    private SyncAccessModeService syncAccessModeService;

    @Inject
    public SyncAccessModeDashboardAction(SyncAccessModeService syncAccessModeService) {
        this.syncAccessModeService = syncAccessModeService;
    }

    public boolean canHandleMessage(String s) {
        return COMMAND.equals(s);
    }

    public String execute(String s) {
        return this.sync();
    }

    private String sync() {
        try {
            Log.warning((String)"Sync accessmode was requested.");
            this.syncAccessModeService.syncAccessMode();
        }
        catch (AccessModeNotAllowedException accessModeNotAllowedException) {
            Log.warning((String)"Dashboard could not sync access mode", (Throwable)accessModeNotAllowedException);
            return "command is not allowed: " + accessModeNotAllowedException.getMessage();
        }
        catch (Exception exception) {
            Log.warning((String)"Dashboard could not sync access mode");
            return RESULT_ERROR;
        }
        return RESULT_OK;
    }
}

