/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.data;

import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.PermissionsService;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.RepositoryException;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PermissionsRepository
implements PermissionsService.Repository {
    private static final String PERMISSIONS_SETTINGS = ".permissions.properties";
    private final WriteableModuleSettings settings = new WriteableModuleSettings(".permissions.properties");

    @Inject
    public PermissionsRepository() {
        if (!this.settings.properties().containsKey("version")) {
            this.settings.properties().setProperty("version", "5.17.1");
            this.settings.properties().setProperty("timestamp", String.valueOf(System.currentTimeMillis()));
            try {
                this.settings.write();
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }
    }

    @Override
    public void setPermissions(String viewName, boolean requiresPassword) {
        try {
            this.settings.properties().setProperty(viewName, Boolean.toString(requiresPassword));
            this.settings.write();
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public boolean isPasswordRequired(String viewName) {
        return this.settings.properties().getBoolean(viewName, false);
    }
}

