/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.domain;

import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.PermissionsService;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AdminLockImpl
implements AdminLock {
    private final Set<AdminLockListener> listeners;
    private final PermissionsService permissionsService;
    private boolean isLocked = true;

    @Inject
    public AdminLockImpl(PermissionsService permissionsService) {
        this.permissionsService = permissionsService;
        this.listeners = new HashSet<AdminLockListener>();
    }

    public void lock() {
        this.isLocked = true;
        this.listeners.forEach(AdminLockListener::doLock);
    }

    public void unlock() {
        this.isLocked = false;
        this.listeners.forEach(AdminLockListener::doUnlock);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void addListener(AdminLockListener listener) {
        String className = listener.getClass().getSimpleName();
        FilterableAdminLockListener filterableAdminLockListener = new FilterableAdminLockListener(listener, this);
        this.permissionsService.addOnChange(className, filterableAdminLockListener);
        this.listeners.add(filterableAdminLockListener);
        if (this.isLocked) {
            filterableAdminLockListener.doLock();
        } else {
            filterableAdminLockListener.doUnlock();
        }
    }

    static class FilterableAdminLockListener
    implements AdminLockListener,
    PermissionsService.OnChange {
        private final AdminLockListener listener;
        private final AdminLockImpl adminLock;
        private boolean filterListenerRequests;

        public FilterableAdminLockListener(AdminLockListener listener, AdminLockImpl adminLock) {
            this.listener = listener;
            this.adminLock = adminLock;
        }

        @Override
        public void permissionsUpdated(boolean requiresPassword) {
            boolean bl = this.filterListenerRequests = !requiresPassword;
            if (requiresPassword && this.adminLock.isLocked()) {
                this.listener.doLock();
            } else {
                this.listener.doUnlock();
            }
        }

        public void doUnlock() {
            if (!this.filterListenerRequests) {
                this.listener.doUnlock();
            }
        }

        public void doLock() {
            if (!this.filterListenerRequests) {
                this.listener.doLock();
            }
        }
    }
}

