/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.domain;

import com.ur.lang.Defense;
import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.InvalidPasswordStrength;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class AdminPassword {
    private static final String SPECIAL_CASE_PASSWORD = "easybot";
    private static final int MINIMUM_PASSWORD_LENGTH = 8;
    private final AtomicReference<String> passwordAsString;
    private final boolean forVerification;

    private AdminPassword(String passwordAsString, boolean forVerification) {
        this.passwordAsString = new AtomicReference<String>(passwordAsString);
        this.forVerification = forVerification;
    }

    public static AdminPassword createForSetNewPassword(String passwordAsString) {
        if (FeatureToggle.isActive((String)"systemPassword")) {
            AdminPassword.validPasswordStrength(passwordAsString);
        }
        return new AdminPassword(passwordAsString, false);
    }

    public static AdminPassword createForVerifyPassword(String passwordAsString) {
        return new AdminPassword(passwordAsString, true);
    }

    private static void validPasswordStrength(String passwordAsString) {
        Defense.notNull((Object)passwordAsString, (String)"Password cannot be null");
        if (SPECIAL_CASE_PASSWORD.equals(passwordAsString)) {
            return;
        }
        if (passwordAsString.length() < 8) {
            throw new InvalidPasswordStrength("Password must be at least 8 characters long");
        }
    }

    public String get() {
        return this.passwordOrThrow(this.passwordAsString.getAndSet(null));
    }

    public boolean isForVerification() {
        return this.forVerification;
    }

    private String passwordOrThrow(String password) {
        if (password == null) {
            throw new IllegalStateException("Sensitive seed has already been consumed");
        }
        return password;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AdminPassword that = (AdminPassword)obj;
        return that.passwordAsString.get().equals(this.passwordAsString.get());
    }

    public int hashCode() {
        return Objects.hash(this.passwordAsString.get());
    }
}

