/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.domain;

import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.AdminPassword;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.PasswordRepository;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.SecurityException;
import com.ur.polyscope.security.impl.useraccess.PasswordStrategy;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AdminPasswordStrategy
implements PasswordStrategy {
    private static final boolean ROOT_PASSWORD_ALWAYS_DEFINED = true;
    private final PasswordRepository passwordRepository;
    private final AdminLock adminLock;

    @Inject
    public AdminPasswordStrategy(PasswordRepository passwordRepository, AdminLock adminLock) {
        this.passwordRepository = passwordRepository;
        this.adminLock = adminLock;
    }

    @Override
    public boolean setPassword(String passwordAsString) {
        try {
            AdminPassword password = AdminPassword.createForSetNewPassword(passwordAsString);
            this.passwordRepository.setPassword(password);
            return this.lock();
        }
        catch (SecurityException e) {
            Log.error((String)("Failed to set password: " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean verifyPassword(String passwordAsString) {
        AdminPassword password = AdminPassword.createForVerifyPassword(passwordAsString);
        return this.passwordRepository.verifyPassword(password);
    }

    @Override
    public boolean clearPassword() {
        throw new UnsupportedOperationException("Not able to clear admin password");
    }

    @Override
    public boolean isPasswordDefined() {
        return true;
    }

    @Override
    public boolean lock() {
        this.adminLock.lock();
        return true;
    }

    @Override
    public boolean isLocked() {
        return this.adminLock.isLocked();
    }
}

