/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.domain;

import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.PasswordUpdateListener;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.AdminPassword;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.CommandFactory;
import com.ur.polyscope.security.impl.cybersecurity.service.SecurityService;
import com.ur.util.event.EventManager;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PasswordChangedWatcher {
    private final Callable<AdminPassword> defaultPassword = () -> AdminPassword.createForVerifyPassword("easybot");
    private final AdminSetProperty settings;
    private final SecurityService service;

    @Inject
    public PasswordChangedWatcher(EventManager eventManager, AdminSetProperty settings, SecurityService service) {
        this.settings = settings;
        this.service = service;
        eventManager.addStrongListener(PasswordUpdateListener.class, this::onPasswordUpdate);
    }

    private void onPasswordUpdate(PasswordManager.Lock lock) {
        if (!this.requiresPasswordChange() || lock != PasswordManager.Lock.ADMIN) {
            return;
        }
        this.settings.enableAdminSet();
    }

    public boolean requiresPasswordChange() {
        return !this.settings.isAdminSet() && this.isPasswordFactoryDefault();
    }

    private boolean isPasswordFactoryDefault() {
        try {
            this.service.invokeCommand(CommandFactory.verifyPasswordCommand(this.defaultPassword.call()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static interface AdminSetProperty {
        public boolean isAdminSet();

        public void enableAdminSet();
    }
}

