/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.domain;

import com.ur.lang.Defense;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.AdminPassword;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.CommandType;
import com.ur.polyscope.security.impl.cybersecurity.service.URAdminException;
import com.ur.polyscope.security.impl.cybersecurity.service.command.Command;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.ArrayUtils;

public class PasswordCommand
implements Command {
    private static final String PASSWORD_PARAM_FORMAT = "root:%s";
    private final CommandType command;
    private final AdminPassword password;

    public PasswordCommand(CommandType command, AdminPassword password) {
        Defense.notNull((Object)((Object)command), (String)"command cannot be null");
        Defense.notNull((Object)password, (String)"password cannot be null");
        this.command = command;
        this.password = password;
    }

    @Override
    public String getCommandType() {
        return this.command.getCommand();
    }

    @Override
    public String[] getParams() {
        return new String[0];
    }

    @Override
    public void validate() {
    }

    @Override
    public ProcessBuilder getProcessBuilder(String processName, boolean ignored) {
        return new ProcessBuilder(processName, this.command.getCommand());
    }

    @Override
    public Process start(ProcessBuilder processBuilder) throws IOException {
        Process process = processBuilder.start();
        PasswordCommand.pipeParamsToProcess(this.passwordCredentials(), process);
        return process;
    }

    private String passwordCredentials() {
        return String.format(PASSWORD_PARAM_FORMAT, this.password.get());
    }

    private static void pipeParamsToProcess(String param, Process process) throws URAdminException {
        try (PipedInputStream inputStream = new PipedInputStream();){
            PasswordCommand.writeParams(param, inputStream);
            PasswordCommand.pipeToProcess(inputStream, process.getOutputStream());
        }
        catch (IOException ex) {
            throw new URAdminException(ex);
        }
    }

    private static void writeParams(String param, PipedInputStream in) throws IOException {
        byte[] paramBytes = param.getBytes(StandardCharsets.UTF_8);
        try (PipedOutputStream out = new PipedOutputStream();){
            out.connect(in);
            out.write(paramBytes, 0, paramBytes.length);
            out.flush();
        }
    }

    private static void pipeToProcess(InputStream in, OutputStream os) throws IOException {
        try {
            int c;
            while ((c = in.read()) != -1) {
                os.write((char)c);
            }
            os.flush();
        }
        finally {
            os.close();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordCommand other = (PasswordCommand)o;
        if (this.command != other.command) {
            return false;
        }
        return ArrayUtils.isEquals((Object)this.getParams(), (Object)other.getParams());
    }

    public int hashCode() {
        int result = this.command.hashCode();
        return 31 * result + ArrayUtils.hashCode((Object)this.password);
    }

    public String getPasswordForSimulated() {
        return this.password.get();
    }

    public void checkPasswordForSimulated(String password) throws URAdminException {
        if (this.password.get().equals(password)) {
            return;
        }
        throw new URAdminException("Wrong password!");
    }
}

