/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.domain;

import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.AdminPassword;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.CommandFactory;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.SecurityException;
import com.ur.polyscope.security.impl.cybersecurity.service.SecurityService;
import com.ur.polyscope.security.impl.cybersecurity.service.URAdminException;
import com.ur.polyscope.security.impl.cybersecurity.service.command.Command;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PasswordRepository {
    private final SecurityService securityService;

    @Inject
    public PasswordRepository(SecurityService securityService) {
        this.securityService = securityService;
    }

    public URAdminState getState() throws SecurityException {
        try {
            return this.securityService.getState();
        }
        catch (URAdminException e) {
            throw new SecurityException(e, true);
        }
    }

    public boolean verifyPassword(AdminPassword passwordCandidate) {
        try {
            this.securityService.invokeCommand(CommandFactory.verifyPasswordCommand(passwordCandidate));
            return true;
        }
        catch (URAdminException e) {
            Log.error((String)("Unable to verify password: " + e.getMessage()));
            return false;
        }
    }

    public void setPassword(AdminPassword newPassword) throws SecurityException {
        this.runCommand(CommandFactory.setPasswordCommand(newPassword));
    }

    private void runCommand(Command command) throws SecurityException {
        try {
            this.securityService.invokeCommand(command);
        }
        catch (URAdminException e) {
            throw new SecurityException(e);
        }
    }
}

