/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PermissionsService {
    private final Map<String, Broadcaster> onChangeMap;
    private final Repository repository;

    @Inject
    public PermissionsService(Repository repository) {
        this.repository = repository;
        this.onChangeMap = new HashMap<String, Broadcaster>();
        Views.viewNames().forEach(viewName -> this.onChangeMap.put((String)viewName, new Broadcaster()));
    }

    public List<Permission> availablePermissions() {
        return Views.viewNames().map(viewName -> new Permission((String)viewName, this.repository.isPasswordRequired((String)viewName))).collect(Collectors.toList());
    }

    public void updatePermission(String viewName, boolean requiresPassword) {
        this.onChangeMap.get(viewName).permissionsUpdated(requiresPassword);
        this.repository.setPermissions(viewName, requiresPassword);
    }

    public void addOnChange(String source, OnChange onChange) {
        Views view = Views.findByClassName(source);
        if (view == null) {
            return;
        }
        this.onChangeMap.get(view.getViewName()).addListener(onChange);
        onChange.permissionsUpdated(this.repository.isPasswordRequired(view.getViewName()));
    }

    public boolean requiresPermission(String viewName) {
        return this.repository.isPasswordRequired(viewName);
    }

    public static interface OnChange {
        public void permissionsUpdated(boolean var1);
    }

    public static interface Repository {
        public void setPermissions(String var1, boolean var2);

        public boolean isPasswordRequired(String var1);
    }

    public static class Permission {
        public final String viewName;
        public final boolean requiresPassword;

        Permission(String viewName, boolean requiresPassword) {
            this.viewName = viewName;
            this.requiresPassword = requiresPassword;
        }
    }

    private static class Broadcaster
    implements OnChange {
        private final List<OnChange> listeners = new ArrayList<OnChange>();

        private Broadcaster() {
        }

        void addListener(OnChange listener) {
            this.listeners.add(listener);
        }

        @Override
        public void permissionsUpdated(boolean isRequired) {
            this.listeners.forEach(l -> l.permissionsUpdated(isRequired));
        }
    }

    public static enum Views {
        SYSTEM_BACKUP("systemBackup", "BackupRestorePanel"),
        LICENSES("licenses", "AbstractLicensePanel", "RobotRegistrationSettingsCompletedViewV1", "LegacyRobotRegistrationSettingsCompletedView", "RobotRegistrationSettingsOfflineView"),
        URCAPS("urcaps", "ManageURCapsViewImpl"),
        REMOTE_CONTROL("remoteControl", "SetupRemoteControlPanel"),
        CONSTRAINED_DRIVE("constrainedFreedrive", "LAFSettingsView"),
        NETWORKING("network", "NetworkingPanel"),
        SOFTWARE_UPDATE("update", "SoftwareUpdatePanel");

        private final String viewName;
        private final List<String> classNames;

        private Views(String viewName, String ... classNames) {
            this.viewName = viewName;
            this.classNames = Arrays.asList(classNames);
        }

        public String getViewName() {
            return this.viewName;
        }

        public static Stream<String> viewNames() {
            return Arrays.stream(Views.values()).map(Views::getViewName);
        }

        private boolean containsClassName(String className) {
            return this.classNames.contains(className);
        }

        public static Views findByClassName(String className) {
            return Arrays.stream(Views.values()).filter(value -> value.containsClassName(className)).findFirst().orElse(null);
        }
    }
}

