/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.view;

import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.InvalidPasswordStrength;
import com.ur.polyscope.security.impl.useraccess.DefaultApplyPasswordStrategy;
import com.ur.polyscope.security.impl.useraccess.UserFeedbackMessages;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.util.swing.HTML;
import javax.swing.JButton;
import javax.swing.JPasswordField;

class ApplyAdminPasswordStrategy
extends DefaultApplyPasswordStrategy {
    private static final String DEFAULT_ADMIN_PASSWORD = "easybot";
    private final TextResource textResource;
    private UserFeedbackMessages userFeedback;

    ApplyAdminPasswordStrategy(TextResource textResource) {
        super(PasswordManager.Lock.ADMIN);
        this.textResource = textResource;
    }

    @Override
    public void setUserFeedback(UserFeedbackMessages userFeedback) {
        this.userFeedback = userFeedback;
        super.setUserFeedback(userFeedback);
    }

    @Override
    public void applyNewPassword(PasswordManager passwordManager, JPasswordField newPassword, JButton applyPassword) {
        if (DEFAULT_ADMIN_PASSWORD.equals(new String(newPassword.getPassword()))) {
            this.userFeedback.messageToUser(newPassword, this.textResource.useDefaultAdminPasswordTitle(), this.createDangerousDefaultPasswordUse());
        }
        this.tryToSetPassword(passwordManager, newPassword, applyPassword);
    }

    private String createDangerousDefaultPasswordUse() {
        return HTML.html((String)HTML.maxWidth((int)240, (String)(HTML.p((String)this.textResource.useDefaultAdminPasswordMessage1()) + HTML.br() + HTML.p((String)this.textResource.useDefaultAdminPasswordMessage2()))));
    }

    private void tryToSetPassword(PasswordManager passwordManager, JPasswordField newPassword, JButton applyPassword) {
        try {
            super.applyNewPassword(passwordManager, newPassword, applyPassword);
        }
        catch (InvalidPasswordStrength pe) {
            this.userFeedback.briefMessageToUser(newPassword, this.textResource.adminPasswordStrengthWarning());
        }
    }
}

