/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.view;

import com.ur.polyscope.security.PasswordManager;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.PasswordChangedWatcher;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.PermissionsService;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;

public class RequireAdminPasswordFooterImpl
extends JPanel
implements RequireAdminPasswordFooter {
    private static final String PASSWORD_FIELD_NAME = "AdminPasswordFooter.passwordField";
    private static final String UNLOCK_BUTTON_NAME = "AdminPasswordFooter.unlockButton";
    private static final String LOCK_BUTTON_NAME = "AdminPasswordFooter.lockButton";
    private static final Dimension BUTTON_DIMENSIONS = new Dimension(95, 26);
    private static final Dimension INPUT_FIELD_DIMENSIONS = new Dimension(165, 26);
    private final List<String> classMatch = Arrays.asList("Thread", "RequireAdminPasswordFooterImpl", "AbstractSystemPanel");
    private final TextResource textResource;
    private final AdminLock adminLock;
    private final PermissionsService permissionsService;
    private final PasswordManager passwordManager;
    private final PasswordChangedWatcher passwordChangeWatcher;
    private JButton lockButton;
    private JButton unlockButton;
    private JPasswordField passwordField;
    private JLabel label;

    @Inject
    public RequireAdminPasswordFooterImpl(TextResource textResource, AdminLock adminLock, PermissionsService permissionsService, PasswordManager passwordManager, PasswordChangedWatcher passwordChangedWatcher) {
        this.textResource = textResource;
        this.adminLock = adminLock;
        this.permissionsService = permissionsService;
        this.passwordManager = passwordManager;
        this.passwordChangeWatcher = passwordChangedWatcher;
        this.initComponents();
    }

    public void resetPasswordField() {
        this.passwordField.setBackground(Color.white);
        DisplayMessageFactory.removeRegistration((JComponent)this.passwordField);
    }

    public JPanel getFooterPanel() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String fullNameForCallingClass = this.returnCallerToGetFooterPanel(stackTrace);
        String callingClass = fullNameForCallingClass.substring(fullNameForCallingClass.lastIndexOf(46) + 1);
        this.permissionsService.addOnChange(callingClass, this::setVisible);
        return this;
    }

    private String returnCallerToGetFooterPanel(StackTraceElement[] stackTrace) {
        for (StackTraceElement stackTraceElement : stackTrace) {
            String className = stackTraceElement.getClassName();
            if (this.classMatch.stream().anyMatch(className::contains)) continue;
            return className;
        }
        return "";
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.lockButton.setVisible(aFlag);
        this.unlockButton.setVisible(aFlag);
        this.passwordField.setVisible(aFlag);
        this.label.setVisible(aFlag);
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, UIManager.getColor("CardPanel.background")));
        this.label = new JLabel(this.textResource.adminPassword());
        this.createUnLockButton();
        this.createPasswordField(this.unlockButton);
        this.createLockButton();
        this.add(this.label);
        this.add(this.passwordField);
        this.add(this.unlockButton);
        this.add(this.lockButton);
        this.add(this.createSpacerLabel(this.label));
        this.adminLock.addListener(new AdminLockListener(){

            public void doUnlock() {
                RequireAdminPasswordFooterImpl.this.setUnlocked();
            }

            public void doLock() {
                RequireAdminPasswordFooterImpl.this.setLocked();
            }
        });
    }

    private JLabel createSpacerLabel(JLabel passwordLabel) {
        JLabel spacerLabel = new JLabel("         ");
        int maxSpacingSize = 9;
        int maxWordSizeAtMaxSpacingSize = 15;
        int spaceCountToRemove = passwordLabel.getText().length() - maxWordSizeAtMaxSpacingSize;
        if (spaceCountToRemove > 0) {
            int spacerTextLength = spaceCountToRemove > maxSpacingSize ? 1 : spaceCountToRemove;
            spacerLabel.setText(spacerLabel.getText().substring(0, spacerTextLength - 1));
        }
        return spacerLabel;
    }

    private void createPasswordField(final JButton unLockButton) {
        this.passwordField = new JPasswordField();
        this.passwordField.setName(PASSWORD_FIELD_NAME);
        this.passwordField.setPreferredSize(INPUT_FIELD_DIMENSIONS);
        this.passwordField.setFocusable(false);
        TextFieldUtils.bindEnterEventToButton((JTextField)this.passwordField, (JButton)unLockButton);
        TextFieldUtils.bindTextPicker((JComponent)this.passwordField, (TextHolder)new TextHolder(){

            public String getText() {
                return "";
            }

            public void setText(String text) {
                SwingUtilities.invokeLater(() -> {
                    RequireAdminPasswordFooterImpl.this.passwordField.setText(text);
                    unLockButton.doClick();
                });
            }
        });
        this.passwordField.getDocument().addDocumentListener((DocumentListener)new DocumentUpdateListener(){

            public void update() {
                if (!new String(RequireAdminPasswordFooterImpl.this.passwordField.getPassword()).isEmpty()) {
                    RequireAdminPasswordFooterImpl.this.resetPasswordField();
                }
            }
        });
    }

    private void createUnLockButton() {
        this.unlockButton = new JButton();
        this.unlockButton.setFocusable(false);
        this.unlockButton.setText(this.textResource.unlock());
        this.unlockButton.setMaximumSize(BUTTON_DIMENSIONS);
        this.unlockButton.setMinimumSize(BUTTON_DIMENSIONS);
        this.unlockButton.setName(UNLOCK_BUTTON_NAME);
        this.unlockButton.addActionListener(this.getUnlockButtonAction());
    }

    private ActionListener getUnlockButtonAction() {
        return e -> {
            if (this.showErrorIfPasswordNotChanged()) {
                return;
            }
            this.unlockPanel();
        };
    }

    private boolean showErrorIfPasswordNotChanged() {
        if (this.passwordChangeWatcher.requiresPasswordChange()) {
            DisplayMessageFactory.error((JComponent)this.passwordField, (String)this.textResource.adminPasswordNotChanged());
            return true;
        }
        return false;
    }

    private void unlockPanel() {
        if (this.passwordManager.verifyPassword(PasswordManager.Lock.ADMIN, new String(this.passwordField.getPassword()))) {
            this.adminLock.unlock();
            return;
        }
        this.adminLock.lock();
        DisplayMessageFactory.error((JComponent)this.passwordField, (String)this.textResource.adminPasswordIncorrect());
    }

    private void createLockButton() {
        this.lockButton = new JButton();
        this.lockButton.setFocusable(false);
        this.lockButton.setText(this.textResource.lock());
        this.lockButton.setMaximumSize(BUTTON_DIMENSIONS);
        this.lockButton.setMinimumSize(BUTTON_DIMENSIONS);
        this.lockButton.setEnabled(false);
        this.lockButton.setName(LOCK_BUTTON_NAME);
        this.lockButton.addActionListener(e -> this.adminLock.lock());
    }

    private void setLocked() {
        this.label.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.passwordField.setText("");
        this.unlockButton.setEnabled(true);
        this.lockButton.setEnabled(false);
    }

    private void setUnlocked() {
        this.label.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.passwordField.setText("");
        this.unlockButton.setEnabled(false);
        this.lockButton.setEnabled(true);
    }
}

