/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.adminrootpasswordlinker.view;

import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.PermissionsService;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

@Singleton
public class SystemPagesPermissionsView
extends CardPanel
implements AdminLockListener {
    private static final String PERMISSIONS_PREFIX = "permissions.";
    private final RequireAdminPasswordFooter passwordFooter;
    private final PermissionsService service;
    private Map<String, JCheckBox> permissionCheckBoxes;

    @Inject
    SystemPagesPermissionsView(RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, AdminLock adminLock, PermissionsService service) {
        this.passwordFooter = passwordFooter;
        this.service = service;
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        Function<PermissionsService.Permission, JCheckBox> factory = SystemPagesPermissionsView.permissionToCheckBoxFunction(service, textResource, widgetFactory);
        this.layoutPanel(this.initializePanel(viewContext.createFormBuilder(), textResource, factory), passwordFooter.getFooterPanel());
        this.add(passwordFooter.getFooterPanel(), "South");
        adminLock.addListener((AdminLockListener)this);
        this.setName(SystemPagesPermissionsView.class.getSimpleName());
    }

    private static Function<PermissionsService.Permission, JCheckBox> permissionToCheckBoxFunction(PermissionsService service, TextResource textResource, WidgetFactory widgetFactory) {
        return permission -> {
            String viewNameTranslation = textResource.get(PERMISSIONS_PREFIX + permission.viewName);
            JCheckBox result = widgetFactory.createCheckBox(viewNameTranslation);
            result.setName(PERMISSIONS_PREFIX + permission.viewName);
            result.setSelected(permission.requiresPassword);
            result.addItemListener(l -> service.updatePermission(permission.viewName, result.isSelected()));
            return result;
        };
    }

    private JPanel initializePanel(FormBuilder formBuilder, TextResource textResource, Function<PermissionsService.Permission, JCheckBox> componentFactory) {
        BiFunction<FormBuilder, JCheckBox, FormBuilder> bindComponentToRow = (fb, j) -> fb.component((JComponent)j, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end();
        this.permissionCheckBoxes = this.service.availablePermissions().stream().map(componentFactory).collect(Collectors.toMap(Component::getName, checkBox -> checkBox, (a, b) -> a, LinkedHashMap::new));
        formBuilder = formBuilder.label(textResource.settingsPermissionsDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end();
        formBuilder = this.permissionCheckBoxes.values().stream().reduce(formBuilder, bindComponentToRow, (a, b) -> a);
        return formBuilder.getCardPanel(textResource.settingsPermissionsTitle());
    }

    private void layoutPanel(JPanel mainPanel, JPanel passwordPanel) {
        this.setLayout(new BorderLayout());
        this.add(mainPanel, "Center");
        this.add(passwordPanel, "South");
    }

    List<JCheckBox> allPermissionSelectors() {
        return new ArrayList<JCheckBox>(this.permissionCheckBoxes.values());
    }

    JCheckBox permissionsSelector(String viewName) {
        return this.permissionCheckBoxes.get(PERMISSIONS_PREFIX + viewName);
    }

    public Object exit() {
        this.passwordFooter.resetPasswordField();
        return super.exit();
    }

    public void doUnlock() {
        this.permissionCheckBoxes.values().forEach(j -> j.setEnabled(true));
    }

    public void doLock() {
        this.permissionCheckBoxes.values().forEach(j -> j.setEnabled(false));
    }
}

