/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.data;

import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.SecurityException;
import com.ur.polyscope.security.impl.cybersecurity.service.SecurityService;
import com.ur.polyscope.security.impl.cybersecurity.service.URAdminException;
import com.ur.polyscope.security.impl.cybersecurity.service.command.Command;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;

class AbstractRepository {
    protected final SecurityService securityService;

    protected AbstractRepository(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected void runCommand(Command command) throws SecurityException {
        try {
            this.securityService.invokeCommand(command);
        }
        catch (URAdminException e) {
            throw new SecurityException(e);
        }
    }

    protected URAdminState runCommandWithState(Command command) throws SecurityException {
        try {
            return this.securityService.invokeCommandWithState(command);
        }
        catch (URAdminException e) {
            throw new SecurityException(e);
        }
    }

    public URAdminState getState() throws SecurityException {
        try {
            return this.securityService.getState();
        }
        catch (URAdminException e) {
            throw new SecurityException(e, true);
        }
    }
}

