/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.data;

import com.ur.polyscope.security.impl.accessmode.AccessModeManager;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.SecurityException;
import com.ur.polyscope.security.impl.cybersecurity.data.AbstractRepository;
import com.ur.polyscope.security.impl.cybersecurity.service.SecurityService;
import com.ur.polyscope.security.impl.cybersecurity.service.command.CommandFactory;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AccessModeRepositoryImpl
extends AbstractRepository
implements AccessModeManager {
    private final ErrorDialogCreator errorDialogCreator;
    private final TextResource textResource;

    @Inject
    protected AccessModeRepositoryImpl(SecurityService securityService, ViewContext viewContext) {
        super(securityService);
        this.errorDialogCreator = viewContext.getDialogCreator();
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
    }

    @Override
    public boolean isRemoteControlActive() {
        try {
            return "remote".equals(this.getControlMode());
        }
        catch (SecurityException e) {
            this.handleSecurityException(e);
            return false;
        }
    }

    private void handleSecurityException(SecurityException e) {
        Log.error((String)"Problem getting control mode from URAdmin script", (Throwable)e);
        this.showErrorDialog(this.textResource.uradminReadTitle(), this.textResource.uradminReadProblem());
    }

    private String getControlMode() throws SecurityException {
        URAdminState state = this.getState();
        return state.getControlMode();
    }

    @Override
    public boolean setRemoteControlActive(boolean active) {
        try {
            this.runCommand(CommandFactory.setControlMode(active ? "remote" : "local"));
            return true;
        }
        catch (SecurityException e) {
            Log.error((String)"Problem setting control mode with URAdmin script", (Throwable)e);
            this.showErrorDialog(this.textResource.uradminWriteTitle(), this.textResource.uradminWriteProblem(this.textResource.remoteControl()));
            return false;
        }
    }

    private void showErrorDialog(String title, String message) {
        this.errorDialogCreator.showErrorDialog(new ErrorMessage(title, message), new OkDialogListener());
    }
}

