/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.data;

import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.SecurityException;
import com.ur.polyscope.security.impl.cybersecurity.data.AbstractRepository;
import com.ur.polyscope.security.impl.cybersecurity.service.SecureShellRepository;
import com.ur.polyscope.security.impl.cybersecurity.service.SecurityService;
import com.ur.polyscope.security.impl.cybersecurity.service.command.CommandFactory;
import com.ur.polyscope.security.impl.cybersecurity.service.model.AuthenticationMethod;
import com.ur.polyscope.security.impl.cybersecurity.service.model.SSHState;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SecureShellRepositoryImpl
extends AbstractRepository
implements SecureShellRepository {
    @Inject
    public SecureShellRepositoryImpl(SecurityService securityService) {
        super(securityService);
    }

    @Override
    public URAdminState setEnableSSHAccess(boolean enableSSHAccess) throws SecurityException {
        return this.runCommandWithState(CommandFactory.enableSSHAccessCommand(this.getCurrentState(), enableSSHAccess));
    }

    @Override
    public URAdminState setAllowPortForwarding(boolean allowPortForwarding) throws SecurityException {
        return this.runCommandWithState(CommandFactory.allowPortForwardingCommand(this.getCurrentState(), allowPortForwarding));
    }

    @Override
    public URAdminState setAuthenticationMethod(AuthenticationMethod authenticationMethod) throws SecurityException {
        return this.runCommandWithState(CommandFactory.sshAuthenticationMethodCommand(this.getCurrentState(), authenticationMethod));
    }

    @Override
    public URAdminState addSSHKeysFromFile(File keyFile) throws SecurityException {
        return this.runCommandWithState(CommandFactory.addSSHKeyCommand(keyFile));
    }

    @Override
    public URAdminState removeSSHKey(int index) throws SecurityException {
        return this.runCommandWithState(CommandFactory.removeSSHKeyCommand(index));
    }

    private SSHState getCurrentState() throws SecurityException {
        URAdminState state = this.getState();
        return state.getSshState();
    }
}

