/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ur.polyscope.security.impl.adminrootpasswordlinker.domain.PasswordCommand;
import com.ur.polyscope.security.impl.cybersecurity.service.SecurityService;
import com.ur.polyscope.security.impl.cybersecurity.service.URAdminException;
import com.ur.polyscope.security.impl.cybersecurity.service.command.Command;
import com.ur.polyscope.security.impl.cybersecurity.service.model.ParamUtil;
import com.ur.polyscope.security.impl.cybersecurity.service.model.SSHState;
import com.ur.polyscope.security.impl.cybersecurity.service.model.StateBuilder;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SimulatedSecurityService
implements SecurityService {
    private static final int MILLIS_TO_DELAY = Integer.parseInt(System.getProperty("simulate.slow.uradmin", "0"));
    private final ObjectMapper objectMapper;
    private URAdminState adminState;
    private String password = "easybot";
    private final Map<String, Invoker> simulatedInvokers = new HashMap<String, Invoker>();

    public SimulatedSecurityService() {
        this.objectMapper = new ObjectMapper();
        this.adminState = this.loadMockedState();
        this.simulatedInvokers.put("autorun", p -> this.setAutorun(p[0]));
        this.simulatedInvokers.put("usb", p -> this.setUsbPorts(p[0]));
        this.simulatedInvokers.put("firewall-restrict-incoming", p -> this.setRestrictIncoming(p[0]));
        this.simulatedInvokers.put("firewall-block-ports", p -> this.setBlockedPorts(p[0]));
        this.simulatedInvokers.put("firewall-service", p -> this.setServiceStatus(p[0], p[1]));
        this.simulatedInvokers.put("ssh", p -> this.setSSHState(p[0], p[2], p[4]));
        this.simulatedInvokers.put("ssh-add-authorized-key", p -> this.addSSHKeys(p[0]));
        this.simulatedInvokers.put("ssh-remove-authorized-key", p -> this.removeSSHKey(p[0]));
        this.simulatedInvokers.put("control-mode", p -> this.setControlMode(p[0]));
    }

    private void simulateSlowResponse() {
        try {
            Thread.sleep(MILLIS_TO_DELAY);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void invokeCommand(Command command) throws URAdminException {
        this.simulateSlowResponse();
        command.validate();
        if (command instanceof PasswordCommand) {
            this.specialPasswordCommandHandling((PasswordCommand)command);
            return;
        }
        String commandCommand = command.getCommandType();
        if (!this.simulatedInvokers.containsKey(commandCommand)) {
            throw new URAdminException("Command " + command.getCommandType() + " not implemented");
        }
        this.simulatedInvokers.get(commandCommand).invoke(command.getParams());
    }

    private void specialPasswordCommandHandling(PasswordCommand command) throws URAdminException {
        if ("passwd-set".equals(command.getCommandType())) {
            this.password = command.getPasswordForSimulated();
        } else {
            command.checkPasswordForSimulated(this.password);
        }
    }

    @Override
    public URAdminState invokeCommandWithState(Command command) throws URAdminException {
        this.invokeCommand(command);
        return this.adminState;
    }

    @Override
    public URAdminState getState() throws URAdminException {
        this.simulateSlowResponse();
        return this.adminState;
    }

    private void setBlockedPorts(String ports) {
        this.adminState = new StateBuilder(this.adminState).withFirewallBlockedPorts(ports).build();
    }

    private void setRestrictIncoming(String subNet) {
        this.adminState = new StateBuilder(this.adminState).withFirewallRestrictIncoming(subNet).build();
    }

    private void setAutorun(String newState) {
        this.adminState = new StateBuilder(this.adminState).withEnableAutorun(ParamUtil.paramToBoolean(newState)).build();
    }

    private void setUsbPorts(String newState) {
        this.adminState = new StateBuilder(this.adminState).withEnableUsbPorts(ParamUtil.paramToBoolean(newState)).build();
    }

    private void setServiceStatus(String newState, String serviceId) {
        this.adminState = new StateBuilder(this.adminState).updateService(serviceId, newState).build();
    }

    private void setSSHState(String state, String portForwarding, String authenticationMethod) {
        List<String> keys = this.adminState.getSshState().getSshKeys();
        SSHState sshState = new SSHState(ParamUtil.paramToBoolean(state), ParamUtil.paramToBoolean(portForwarding), ParamUtil.authMethodFromParameter(authenticationMethod), keys);
        this.adminState = new StateBuilder(this.adminState).withSSHState(sshState).build();
    }

    private void setControlMode(String controlMode) {
        this.adminState = new StateBuilder(this.adminState).withControlMode(controlMode).build();
    }

    private void addSSHKeys(String keyFilePath) {
        File keyFile = new File(keyFilePath);
        List<String> lines = this.readFileByLine(keyFile);
        HashSet<String> keySet = new HashSet<String>(this.adminState.getSshState().getSshKeys());
        keySet.addAll(lines);
        SSHState currentState = this.adminState.getSshState();
        ArrayList<String> keys = new ArrayList<String>(keySet);
        SSHState state = new SSHState(currentState.isEnabled(), currentState.isAllowPortForwarding(), currentState.getAuthenticationMethod(), keys);
        this.adminState = new StateBuilder(this.adminState).withSSHState(state).build();
    }

    private void removeSSHKey(String key) {
        SSHState sshState = this.adminState.getSshState();
        ArrayList<String> keys = new ArrayList<String>(sshState.getSshKeys());
        int index = Integer.parseInt(key);
        keys.remove(index);
        this.adminState = new StateBuilder(this.adminState).withSSHState(new SSHState(sshState.isEnabled(), sshState.isAllowPortForwarding(), sshState.getAuthenticationMethod(), keys)).build();
    }

    private List<String> readFileByLine(File keyFile) {
        List lines;
        try {
            lines = FileUtils.readLines((File)keyFile, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
        return lines;
    }

    private URAdminState loadMockedState() {
        URAdminState result = null;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("mock/default-state.json");
            String json = IOUtils.toString((InputStream)is);
            result = (URAdminState)this.objectMapper.readValue(json, URAdminState.class);
        }
        catch (Exception e) {
            Log.error((String)"Failed to load mock values for URAdmin State", (Throwable)e);
        }
        return result;
    }

    static interface Invoker {
        public void invoke(String[] var1);
    }
}

