/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ur.polyscope.security.impl.cybersecurity.service.SecurityService;
import com.ur.polyscope.security.impl.cybersecurity.service.URAdminException;
import com.ur.polyscope.security.impl.cybersecurity.service.command.Command;
import com.ur.polyscope.security.impl.cybersecurity.service.command.CommandFactory;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class URAdminSecurityService
implements SecurityService {
    private static final String PYTHON_ENCODING = "PYTHONIOENCODING";
    private static final String URADMIN_COMMAND = "uradmin";
    private final ProcessRunner processRunner;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    private URAdminSecurityService() {
        this(new DefaultProcessRunner());
    }

    URAdminSecurityService(ProcessRunner processRunner) {
        this.processRunner = processRunner;
    }

    @Override
    public void invokeCommand(Command command) throws URAdminException {
        this.invokeURAdmin(command, false);
    }

    @Override
    public URAdminState invokeCommandWithState(Command command) throws URAdminException {
        return this.readURAdminState(this.invokeURAdmin(command, true));
    }

    @Override
    public URAdminState getState() throws URAdminException {
        Command command = CommandFactory.getStateCommand();
        return this.readURAdminState(this.invokeURAdmin(command, false));
    }

    private URAdminState readURAdminState(String json) throws URAdminException {
        try {
            return (URAdminState)this.objectMapper.readValue(json, URAdminState.class);
        }
        catch (IOException e) {
            throw new URAdminException(e);
        }
    }

    private String invokeURAdmin(Command command, boolean appendWithState) throws URAdminException {
        command.validate();
        ProcessBuilder processBuilder = this.getProcessBuilder(command, appendWithState);
        try {
            Process process = this.processRunner.start(processBuilder, command);
            int exitCode = process.waitFor();
            String output = this.getOutput(process);
            if (exitCode != 0) {
                throw new URAdminException("Error in URAdmin: " + output);
            }
            return output;
        }
        catch (IOException | InterruptedException e) {
            throw new URAdminException(e);
        }
    }

    private ProcessBuilder getProcessBuilder(Command command, boolean appendWithState) {
        ProcessBuilder processBuilder = command.getProcessBuilder(URADMIN_COMMAND, appendWithState);
        processBuilder.redirectErrorStream(true);
        processBuilder.environment().put(PYTHON_ENCODING, "utf-8");
        return processBuilder;
    }

    private String getOutput(Process process) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    static class DefaultProcessRunner
    implements ProcessRunner {
        DefaultProcessRunner() {
        }

        @Override
        public Process start(ProcessBuilder builder, Command command) throws URAdminException {
            try {
                return command.start(builder);
            }
            catch (IOException e) {
                throw new URAdminException(e);
            }
        }
    }

    static interface ProcessRunner {
        public Process start(ProcessBuilder var1, Command var2) throws URAdminException;
    }
}

