/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.command;

import com.ur.polyscope.security.impl.cybersecurity.service.command.Command;
import com.ur.polyscope.security.impl.cybersecurity.service.command.CommandImpl;
import com.ur.polyscope.security.impl.cybersecurity.service.command.CommandType;
import com.ur.polyscope.security.impl.cybersecurity.service.model.AuthenticationMethod;
import com.ur.polyscope.security.impl.cybersecurity.service.model.ParamUtil;
import com.ur.polyscope.security.impl.cybersecurity.service.model.SSHState;
import java.io.File;

public final class CommandFactory {
    private static final String PORT_FORWARDING_PARAM = "--port-forwarding";
    private static final String AUTHENTICATION_PARAM = "--authentication";

    private CommandFactory() {
    }

    public static Command getStateCommand() {
        return new CommandImpl(CommandType.GET_STATE, new String[0]);
    }

    public static Command autorunCommand(boolean enable) {
        return new CommandImpl(CommandType.SET_AUTORUN_STATUS, ParamUtil.booleanToParamString(enable));
    }

    public static Command enableUsbPortsCommand(boolean allowUsbPorts) {
        return new CommandImpl(CommandType.SET_USB_PORTS, ParamUtil.booleanToParamString(allowUsbPorts));
    }

    public static Command restrictIncomingCommand(String restrictedSubnet) {
        return new CommandImpl(CommandType.SET_RESTRICT_INCOMING, restrictedSubnet);
    }

    public static Command disablePortsCommand(String disabledPorts) {
        return new CommandImpl(CommandType.SET_BLOCKED_PORTS, disabledPorts);
    }

    public static Command enableSSHAccessCommand(SSHState currentState, boolean enable) {
        return new CommandImpl(CommandType.SSH, ParamUtil.booleanToParamString(enable), PORT_FORWARDING_PARAM, ParamUtil.booleanToParamString(currentState.isAllowPortForwarding()), AUTHENTICATION_PARAM, ParamUtil.authMethodToParameter(currentState.getAuthenticationMethod()));
    }

    public static Command allowPortForwardingCommand(SSHState currentState, boolean enable) {
        return new CommandImpl(CommandType.SSH, ParamUtil.booleanToParamString(currentState.isEnabled()), PORT_FORWARDING_PARAM, ParamUtil.booleanToParamString(enable), AUTHENTICATION_PARAM, ParamUtil.authMethodToParameter(currentState.getAuthenticationMethod()));
    }

    public static Command sshAuthenticationMethodCommand(SSHState currentState, AuthenticationMethod authenticationMethod) {
        return new CommandImpl(CommandType.SSH, ParamUtil.booleanToParamString(currentState.isEnabled()), PORT_FORWARDING_PARAM, ParamUtil.booleanToParamString(currentState.isAllowPortForwarding()), AUTHENTICATION_PARAM, ParamUtil.authMethodToParameter(authenticationMethod));
    }

    public static Command addSSHKeyCommand(File keyFile) {
        return new CommandImpl(CommandType.ADD_SSH_KEYS, keyFile.getAbsolutePath());
    }

    public static Command removeSSHKeyCommand(int index) {
        return new CommandImpl(CommandType.REMOVE_SSH_KEY, Integer.toString(index));
    }

    public static Command toggleServiceStatusCommand(String serviceId, boolean enable) {
        return new CommandImpl(CommandType.TOGGLE_SERVICE_ENABLED, ParamUtil.booleanToParamString(enable), serviceId);
    }

    public static Command setControlMode(String controlMode) {
        return new CommandImpl(CommandType.SET_CONTROL_MODE, controlMode);
    }
}

