/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.command;

import com.ur.polyscope.security.impl.cybersecurity.service.URAdminException;
import com.ur.polyscope.security.impl.cybersecurity.service.command.Command;
import com.ur.polyscope.security.impl.cybersecurity.service.command.CommandType;
import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;

class CommandImpl
implements Command {
    private static final String WITH_STATE = "--print-state";
    private final CommandType command;
    private final String[] params;

    public CommandImpl(CommandType command, String ... params) {
        this.command = command;
        this.params = (String[])params.clone();
    }

    @Override
    public String getCommandType() {
        return this.command.getCommand();
    }

    @Override
    public String[] getParams() {
        return (String[])this.params.clone();
    }

    @Override
    public void validate() throws URAdminException {
        if (this.params.length != this.command.getExpectedNumberOfParams()) {
            throw new URAdminException(this.command.name() + ": Wrong number of arguments (expected " + this.command.getExpectedNumberOfParams() + ", got " + this.params.length + ")");
        }
    }

    @Override
    public ProcessBuilder getProcessBuilder(String processName, boolean appendWithState) {
        Object[] commandArray = (String[])ArrayUtils.addAll((Object[])new String[]{processName + "-" + this.command.getCommand()}, (Object[])((Object[])this.params.clone()));
        if (appendWithState) {
            commandArray = (String[])ArrayUtils.add((Object[])commandArray, (Object)WITH_STATE);
        }
        return new ProcessBuilder((String[])commandArray);
    }

    @Override
    public Process start(ProcessBuilder processBuilder) throws IOException {
        return processBuilder.start();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandImpl other = (CommandImpl)o;
        if (this.command != other.command) {
            return false;
        }
        return ArrayUtils.isEquals((Object)this.getParams(), (Object)other.getParams());
    }

    public int hashCode() {
        int result = this.command.hashCode();
        return 31 * result + ArrayUtils.hashCode((Object)this.params);
    }
}

