/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FirewallService {
    private final String id;
    private final String description;
    private final List<String> interfaces;
    private final ServiceInfo serviceInfo;

    @JsonCreator
    FirewallService(@JsonProperty(value="id") String id, @JsonProperty(value="description") String description, @JsonProperty(value="interfaces") List<String> interfaces, @JsonProperty(value="info") ServiceInfo serviceInfo) {
        this.id = id;
        this.description = description;
        this.interfaces = Collections.unmodifiableList(interfaces);
        this.serviceInfo = serviceInfo;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return !this.interfaces.isEmpty();
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    private static class ServiceInfo {
        private final Map<String, List<String>> ports;
        private final Map<String, List<String>> localForward;

        @JsonCreator
        ServiceInfo(@JsonProperty(value="ports") Map<String, List<String>> ports, @JsonProperty(value="local-port-forwards") Map<String, List<String>> localForward) {
            this.ports = ports;
            this.localForward = localForward;
        }

        public Map<String, List<String>> getPorts() {
            return this.ports;
        }

        public Map<String, List<String>> getLocalForward() {
            return this.localForward;
        }
    }
}

