/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ur.polyscope.security.impl.cybersecurity.service.model.AuthenticationMethod;
import com.ur.polyscope.security.impl.cybersecurity.service.model.SSHStateDeserializer;
import java.util.Collections;
import java.util.List;

@JsonDeserialize(using=SSHStateDeserializer.class)
public class SSHState {
    private final boolean enabled;
    private final boolean allowPortForwarding;
    private final AuthenticationMethod authenticationMethod;
    private final List<String> sshKeys;

    @JsonCreator
    public SSHState(boolean enabled, boolean allowPortForwarding, AuthenticationMethod authenticationMethod, List<String> sshKeys) {
        this.enabled = enabled;
        this.allowPortForwarding = allowPortForwarding;
        this.authenticationMethod = authenticationMethod;
        this.sshKeys = Collections.unmodifiableList(sshKeys);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAllowPortForwarding() {
        return this.allowPortForwarding;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public List<String> getSshKeys() {
        return Collections.unmodifiableList(this.sshKeys);
    }
}

