/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.ur.polyscope.security.impl.cybersecurity.service.model.AuthenticationMethod;
import com.ur.polyscope.security.impl.cybersecurity.service.model.ParamUtil;
import com.ur.polyscope.security.impl.cybersecurity.service.model.SSHState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SSHStateDeserializer
extends StdDeserializer<SSHState> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    protected SSHStateDeserializer() {
        super(SSHState.class);
    }

    public SSHState deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        boolean enabled = ParamUtil.paramToBoolean(this.getNodeText(node, "state"));
        boolean allowPortForward = ParamUtil.paramToBoolean(this.getNodeText(node, "port-forward"));
        AuthenticationMethod authMethod = this.parseAuthenticationMethod(node);
        List<String> sshKeys = this.readSSHKeys(node);
        return new SSHState(enabled, allowPortForward, authMethod, sshKeys);
    }

    private AuthenticationMethod parseAuthenticationMethod(JsonNode node) throws JsonProcessingException {
        JsonNode authNode = node.get("authentication");
        AuthenticationMethod authMethod = AuthenticationMethod.BOTH;
        if (authNode != null) {
            authMethod = (AuthenticationMethod)((Object)this.objectMapper.treeToValue((TreeNode)authNode, AuthenticationMethod.class));
        }
        return authMethod;
    }

    private String getNodeText(JsonNode node, String fieldName) {
        JsonNode jsonNode = node.get(fieldName);
        return jsonNode != null ? jsonNode.asText() : "";
    }

    private List<String> readSSHKeys(JsonNode node) {
        ArrayList<String> sshKeys = new ArrayList<String>();
        JsonNode keysNode = node.get("keys");
        if (keysNode != null) {
            for (JsonNode jsonNode : keysNode) {
                sshKeys.add(jsonNode.asText());
            }
        }
        return sshKeys;
    }
}

