/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class ServiceInterface {
    private static final String SUBNET = "subnet";
    private final String blockedPorts;
    private final String restrictedSubnet;

    @JsonCreator
    public ServiceInterface(@JsonProperty(value="blocked-ports") Map<String, List<String>> blockedPortsByProtocol, @JsonProperty(value="restrict-incoming") Map<String, String> restrictedSubnets) {
        String string = this.restrictedSubnet = restrictedSubnets != null ? restrictedSubnets.get(SUBNET) : null;
        if (blockedPortsByProtocol != null) {
            TreeSet<String> ports = new TreeSet<String>();
            for (List<String> list : blockedPortsByProtocol.values()) {
                ports.addAll(list);
            }
            this.blockedPorts = StringUtils.join(ports, (char)',');
        } else {
            this.blockedPorts = null;
        }
    }

    public String getBlockedPorts() {
        return this.blockedPorts;
    }

    public String getRestrictedSubnet() {
        return this.restrictedSubnet;
    }
}

