/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.model;

import com.ur.polyscope.security.impl.cybersecurity.service.model.Firewall;
import com.ur.polyscope.security.impl.cybersecurity.service.model.FirewallService;
import com.ur.polyscope.security.impl.cybersecurity.service.model.ParamUtil;
import com.ur.polyscope.security.impl.cybersecurity.service.model.SSHState;
import com.ur.polyscope.security.impl.cybersecurity.service.model.ServiceInterface;
import com.ur.polyscope.security.impl.cybersecurity.service.model.URAdminState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StateBuilder {
    private static final String TCP_PROTOCOL = "tcp";
    private static final String SUBNET_KEY = "subnet";
    private static final String ETH0_INTERFACE = "eth0";
    private final String uradmin;
    private String controlMode;
    private boolean enableAutorun;
    private boolean enableUsb;
    private ServiceInterface firewallServiceInterface;
    private final List<FirewallService> firewallServices;
    private SSHState sshState;

    public StateBuilder(URAdminState adminState) {
        this.uradmin = adminState.getUradmin();
        this.enableAutorun = adminState.isAutorunEnabled();
        this.enableUsb = adminState.isUsbEnabled();
        this.controlMode = adminState.getControlMode();
        this.firewallServices = new ArrayList<FirewallService>(adminState.getFirewall().getServices());
        this.firewallServiceInterface = adminState.getFirewall().getServiceInterface();
        this.sshState = adminState.getSshState();
    }

    public StateBuilder withEnableAutorun(boolean enableAutorun) {
        this.enableAutorun = enableAutorun;
        return this;
    }

    public StateBuilder withEnableUsbPorts(boolean enableUsbPorts) {
        this.enableUsb = enableUsbPorts;
        return this;
    }

    public StateBuilder withFirewallRestrictIncoming(String firewallRestrictIncoming) {
        Map<String, List<String>> blockedPortsByProtocol = this.getExistingBlockedPortsMap();
        Map<String, String> restrictedSubnets = this.createSubnetMap(firewallRestrictIncoming);
        this.firewallServiceInterface = new ServiceInterface(blockedPortsByProtocol, restrictedSubnets);
        return this;
    }

    public StateBuilder withControlMode(String controlMode) {
        this.controlMode = controlMode;
        return this;
    }

    public StateBuilder withFirewallBlockedPorts(String firewallBlockedPorts) {
        Map<String, List<String>> blockedPortsMap = this.createBlockedPortsMap(firewallBlockedPorts);
        Map<String, String> subnetMap = this.getExistingSubnetMap();
        this.firewallServiceInterface = new ServiceInterface(blockedPortsMap, subnetMap);
        return this;
    }

    public StateBuilder updateService(String id, String newState) {
        FirewallService foundService = null;
        for (FirewallService s : this.firewallServices) {
            if (!s.getId().equals(id)) continue;
            foundService = s;
            break;
        }
        if (foundService != null) {
            List<String> interfaces = ParamUtil.paramToBoolean(newState) ? Collections.singletonList(ETH0_INTERFACE) : Collections.emptyList();
            int index = this.firewallServices.indexOf(foundService);
            this.firewallServices.set(index, new FirewallService(id, foundService.getDescription(), interfaces, foundService.getServiceInfo()));
        }
        return this;
    }

    public StateBuilder withSSHState(SSHState services) {
        this.sshState = services;
        return this;
    }

    public URAdminState build() {
        Map<String, ServiceInterface> serviceInterfaceMap = null;
        if (this.firewallServiceInterface != null) {
            serviceInterfaceMap = Collections.singletonMap(ETH0_INTERFACE, this.firewallServiceInterface);
        }
        return new URAdminState(this.uradmin, this.enableAutorun, this.enableUsb, this.controlMode, new Firewall(this.firewallServices, serviceInterfaceMap), this.sshState);
    }

    private Map<String, String> getExistingSubnetMap() {
        String subnet = this.firewallServiceInterface != null ? this.firewallServiceInterface.getRestrictedSubnet() : "";
        return this.createSubnetMap(subnet);
    }

    private Map<String, String> createSubnetMap(String firewallRestrictIncoming) {
        HashMap<String, String> restrictedSubnets = new HashMap<String, String>();
        restrictedSubnets.put(SUBNET_KEY, firewallRestrictIncoming);
        return restrictedSubnets;
    }

    private Map<String, List<String>> getExistingBlockedPortsMap() {
        String ports = this.firewallServiceInterface != null ? this.firewallServiceInterface.getBlockedPorts() : null;
        return this.createBlockedPortsMap(ports);
    }

    private Map<String, List<String>> createBlockedPortsMap(String blockedPorts) {
        HashMap<String, List<String>> blockedPortsByProtocol = new HashMap<String, List<String>>();
        if (blockedPorts != null) {
            blockedPortsByProtocol.put(TCP_PROTOCOL, Arrays.asList(blockedPorts.split(",")));
        }
        return blockedPortsByProtocol;
    }
}

