/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.validation;

import com.ur.polyscope.security.impl.cybersecurity.service.validation.ParamValidator;
import com.ur.polyscope.security.impl.cybersecurity.service.validation.ValidatorException;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.swing.validation.IpAddressValidator;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class IPSubnetValidator
extends ParamValidator {
    private static final String SUBNET_SEPARATOR = "/";
    private static final String ADDRESS_REGEX = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SUBNET_REGEX = "/(\\d{1,2})";
    private static final Pattern IP_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern IP_AND_SUBNET_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})");
    private static final int MAX_SUBNET = 32;
    private final IpAddressValidator ipAddressValidator = new IpAddressValidator();

    @Inject
    public IPSubnetValidator(TextResource textResource) {
        super(textResource);
    }

    @Override
    ParamValidator.PatternValidator getPatternValidator(String input) {
        return new ParamValidator.PatternValidator(input, this.textResource.miscInvalidIpSubnet(input), IP_PATTERN, IP_AND_SUBNET_PATTERN);
    }

    @Override
    void validateContent(String input) throws ValidatorException {
        if (!input.trim().isEmpty()) {
            if (input.contains(SUBNET_SEPARATOR)) {
                String[] split = input.split(SUBNET_SEPARATOR);
                this.validateIpAddress(split[0]);
                this.validateSubnet(split[1]);
            } else {
                this.validateIpAddress(input);
            }
        }
    }

    private void validateIpAddress(String ip) throws ValidatorException {
        if (!this.ipAddressValidator.isValid(ip)) {
            throw new ValidatorException(this.textResource.miscInvalidIpaddress(ip));
        }
    }

    private void validateSubnet(String subnetStr) throws ValidatorException {
        int subnet = this.parseInt(subnetStr);
        if (subnet < 0 || subnet > 32) {
            throw new ValidatorException(this.textResource.miscInvalidSubnet(subnetStr));
        }
    }
}

