/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.validation;

import com.ur.polyscope.security.impl.cybersecurity.service.validation.ValidatorException;
import com.ur.polyscope.security.internal.TextResource;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.inject.Inject;

abstract class ParamValidator {
    protected final TextResource textResource;

    @Inject
    public ParamValidator(TextResource textResource) {
        this.textResource = textResource;
    }

    public void validate(String input) throws ValidatorException {
        this.getPatternValidator(input).validate();
        this.validateContent(input);
    }

    abstract PatternValidator getPatternValidator(String var1);

    abstract void validateContent(String var1) throws ValidatorException;

    protected int parseInt(String s) throws ValidatorException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new ValidatorException(this.textResource.miscInvalidNumber(s));
        }
    }

    protected static class PatternValidator {
        private final String input;
        private final String errorMessage;
        private final Pattern[] validationPatterns;

        public PatternValidator(String input, String errorMessage, Pattern ... validationPatterns) {
            this.input = input;
            this.errorMessage = errorMessage;
            this.validationPatterns = Arrays.copyOf(validationPatterns, validationPatterns.length);
        }

        private void validate() throws ValidatorException {
            boolean foundMatch = false;
            if (this.input.trim().isEmpty()) {
                foundMatch = true;
            } else {
                for (Pattern pattern : this.validationPatterns) {
                    foundMatch = foundMatch || pattern.matcher(this.input).matches();
                }
            }
            if (!foundMatch) {
                throw new ValidatorException(this.errorMessage);
            }
        }
    }
}

