/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.service.validation;

import com.ur.polyscope.security.impl.cybersecurity.service.validation.ParamValidator;
import com.ur.polyscope.security.impl.cybersecurity.service.validation.ValidatorException;
import com.ur.polyscope.security.internal.TextResource;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class PortRangeValidator
extends ParamValidator {
    private static final String RANGE_SEPARATOR = "-";
    private static final int MAX_PORT = 65535;
    private static final String PORT_RANGE_REGEX = "\\d{1,5}(-\\d{1,5})?";
    private static final Pattern PORT_RANGE_PATTERN = Pattern.compile("\\d{1,5}(-\\d{1,5})?(,\\s?\\d{1,5}(-\\d{1,5})?)*");

    @Inject
    public PortRangeValidator(TextResource textResource) {
        super(textResource);
    }

    @Override
    ParamValidator.PatternValidator getPatternValidator(String input) {
        return new ParamValidator.PatternValidator(input, this.textResource.miscInvalidPortOrRange(input), PORT_RANGE_PATTERN);
    }

    @Override
    void validateContent(String input) throws ValidatorException {
        if (!input.trim().isEmpty()) {
            String[] split;
            for (String portEntry : split = input.split(",")) {
                if ((portEntry = portEntry.trim()).contains(RANGE_SEPARATOR)) {
                    this.validatePortRange(portEntry);
                    continue;
                }
                this.validatePort(this.parseInt(portEntry));
            }
        }
    }

    private void validatePortRange(String portRange) throws ValidatorException {
        String[] range = portRange.split(RANGE_SEPARATOR);
        int p1 = this.parseInt(range[0]);
        this.validatePort(p1);
        int p2 = this.parseInt(range[1]);
        this.validatePort(p2);
        if (p1 > p2) {
            throw new ValidatorException(this.textResource.miscInvalidPortRange(portRange));
        }
    }

    private void validatePort(int port) throws ValidatorException {
        if (port <= 0 || port > 65535) {
            throw new ValidatorException(this.textResource.miscInvalidPort(Integer.toString(port)));
        }
    }
}

