/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.security.impl.cybersecurity.ui;

import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.security.internal.TextResource;
import com.ur.polyscope.settings.SettingsSectionName;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.g5.CardBorder;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public abstract class AbstractSecurityPanel
extends CardPanel
implements AdminLockListener {
    protected static final String URADMIN_READ_ERROR = "Error reading URAdmin state";
    protected static final Color BACKGROUND_COLOR = UIManager.getColor("CardPanel.background");
    protected final TextResource textResource;
    protected final ViewContext viewContext;
    protected final AdminLock adminLock;
    private final ErrorDialogCreator errorDialogCreator;
    private final RequireAdminPasswordFooter passwordFooter;

    protected AbstractSecurityPanel(RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, AdminLock adminLock, ErrorDialogCreator errorDialogCreator) {
        this.passwordFooter = passwordFooter;
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.adminLock = adminLock;
        this.errorDialogCreator = errorDialogCreator;
        this.putClientProperty("SettingsSectionName", SettingsSectionName.SECURITY);
        this.initComponents();
        this.addPasswordFooter(passwordFooter);
        adminLock.addListener((AdminLockListener)this);
    }

    public void enter(Object o) {
        super.enter(o);
        this.update();
    }

    public Object exit() {
        this.cleanup();
        return super.exit();
    }

    public void doUnlock() {
        for (JComponent lockableComponent : this.getLockableComponents()) {
            lockableComponent.setEnabled(true);
        }
    }

    public void doLock() {
        for (JComponent lockableComponent : this.getLockableComponents()) {
            lockableComponent.setEnabled(false);
        }
    }

    abstract void initComponents();

    abstract void update();

    abstract List<JComponent> getLockableComponents();

    void cleanup() {
        this.passwordFooter.resetPasswordField();
    }

    private void addPasswordFooter(RequireAdminPasswordFooter passwordFooter) {
        this.add(this.createCard(null, passwordFooter.getFooterPanel()), "South");
    }

    protected JPanel createCard(String cardTitle, JComponent panel) {
        JPanel result = new JPanel(new BorderLayout());
        if (cardTitle != null) {
            result.setBorder((Border)new CardBorder(cardTitle));
        }
        result.add((Component)panel, "Center");
        return result;
    }

    protected void handleError(Throwable e, String dialogTitle, String dialogErrorMessage, String logErrorMessage) {
        this.showErrorDialog(dialogTitle, dialogErrorMessage);
        Log.error((String)logErrorMessage, (Throwable)e);
    }

    private void showErrorDialog(String title, String message) {
        this.errorDialogCreator.showErrorDialog(new ErrorMessage(title, message), new OkDialogListener());
    }
}

